/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.AuthenticatorAttachment;

class AuthenticatorAttachmentDeserializer
extends StdDeserializer<AuthenticatorAttachment> {
    AuthenticatorAttachmentDeserializer() {
        super(AuthenticatorAttachment.class);
    }

    public @Nullable AuthenticatorAttachment deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JacksonException {
        String type = (String)parser.readValueAs(String.class);
        for (AuthenticatorAttachment publicKeyCredentialType : AuthenticatorAttachment.values()) {
            if (!publicKeyCredentialType.getValue().equals(type)) continue;
            return publicKeyCredentialType;
        }
        return null;
    }
}

