/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authorization.AuthorityAuthorizationDecision;
import org.springframework.security.authorization.AuthorizationDeniedException;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.FactorAuthorizationDecision;
import org.springframework.security.authorization.RequiredFactor;
import org.springframework.security.authorization.RequiredFactorError;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.WebAttributes;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.util.Assert;

public final class DelegatingMissingAuthorityAccessDeniedHandler
implements AccessDeniedHandler {
    private final ThrowableAnalyzer throwableAnalyzer = new ThrowableAnalyzer();
    private final Map<String, AuthenticationEntryPoint> entryPoints;
    private RequestCache requestCache = new NullRequestCache();
    private AccessDeniedHandler defaultAccessDeniedHandler = new AccessDeniedHandlerImpl();

    private DelegatingMissingAuthorityAccessDeniedHandler(Map<String, AuthenticationEntryPoint> entryPoints) {
        Assert.notEmpty(entryPoints, (String)"entryPoints cannot be empty");
        this.entryPoints = entryPoints;
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException denied) throws IOException, ServletException {
        List<AuthorityRequiredFactorErrorEntry> errorEntries = this.authorityErrors(denied);
        List<RequiredFactorError> errors = errorEntries.stream().map(AuthorityRequiredFactorErrorEntry::getError).filter(Objects::nonNull).toList();
        for (AuthorityRequiredFactorErrorEntry authorityError : errorEntries) {
            String requiredAuthority = authorityError.getAuthority();
            AuthenticationEntryPoint entryPoint = this.entryPoints.get(requiredAuthority);
            if (entryPoint == null) continue;
            this.requestCache.saveRequest(request, response);
            if (!errors.isEmpty()) {
                request.setAttribute(WebAttributes.REQUIRED_FACTOR_ERRORS, errors);
            }
            String message = String.format("Missing Authorities %s", requiredAuthority);
            InsufficientAuthenticationException ex = new InsufficientAuthenticationException(message, (Throwable)denied);
            entryPoint.commence(request, response, (AuthenticationException)ex);
            return;
        }
        this.defaultAccessDeniedHandler.handle(request, response, denied);
    }

    public void setDefaultAccessDeniedHandler(AccessDeniedHandler defaultAccessDeniedHandler) {
        Assert.notNull((Object)defaultAccessDeniedHandler, (String)"defaultAccessDeniedHandler cannot be null");
        this.defaultAccessDeniedHandler = defaultAccessDeniedHandler;
    }

    public void setRequestCache(RequestCache requestCache) {
        Assert.notNull((Object)requestCache, (String)"requestCachgrantedaue cannot be null");
        this.requestCache = requestCache;
    }

    private List<AuthorityRequiredFactorErrorEntry> authorityErrors(AccessDeniedException ex) {
        AuthorizationDeniedException denied = this.findAuthorizationDeniedException(ex);
        if (denied == null) {
            return List.of();
        }
        AuthorizationResult authorizationResult = denied.getAuthorizationResult();
        if (authorizationResult instanceof FactorAuthorizationDecision) {
            FactorAuthorizationDecision factorDecision = (FactorAuthorizationDecision)authorizationResult;
            return factorDecision.getFactorErrors().stream().map(error -> {
                String authority = error.getRequiredFactor().getAuthority();
                return new AuthorityRequiredFactorErrorEntry(authority, (RequiredFactorError)error);
            }).collect(Collectors.toList());
        }
        if (authorizationResult instanceof AuthorityAuthorizationDecision) {
            AuthorityAuthorizationDecision authorityDecision = (AuthorityAuthorizationDecision)authorizationResult;
            return authorityDecision.getAuthorities().stream().map(grantedAuthority -> {
                String authority = grantedAuthority.getAuthority();
                if (authority.startsWith("FACTOR_")) {
                    RequiredFactor required = RequiredFactor.withAuthority((String)authority).build();
                    return new AuthorityRequiredFactorErrorEntry(authority, RequiredFactorError.createMissing((RequiredFactor)required));
                }
                return new AuthorityRequiredFactorErrorEntry(authority, null);
            }).collect(Collectors.toList());
        }
        return List.of();
    }

    private @Nullable AuthorizationDeniedException findAuthorizationDeniedException(AccessDeniedException ex) {
        if (ex instanceof AuthorizationDeniedException) {
            AuthorizationDeniedException denied = (AuthorizationDeniedException)ex;
            return denied;
        }
        Throwable[] chain = this.throwableAnalyzer.determineCauseChain((Throwable)ex);
        return (AuthorizationDeniedException)this.throwableAnalyzer.getFirstThrowableOfType(AuthorizationDeniedException.class, chain);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class AuthorityRequiredFactorErrorEntry {
        private final String authority;
        private final @Nullable RequiredFactorError error;

        private AuthorityRequiredFactorErrorEntry(String authority, @Nullable RequiredFactorError error) {
            Assert.notNull((Object)authority, (String)"authority cannot be null");
            this.authority = authority;
            this.error = error;
        }

        private String getAuthority() {
            return this.authority;
        }

        private @Nullable RequiredFactorError getError() {
            return this.error;
        }
    }

    public static final class Builder {
        private final Map<String, DelegatingAuthenticationEntryPoint.Builder> entryPointBuilderByAuthority = new LinkedHashMap<String, DelegatingAuthenticationEntryPoint.Builder>();

        private Builder() {
        }

        public Builder addEntryPointFor(AuthenticationEntryPoint entryPoint, String missingAuthority) {
            DelegatingAuthenticationEntryPoint.Builder builder = DelegatingAuthenticationEntryPoint.builder().addEntryPointFor(entryPoint, AnyRequestMatcher.INSTANCE);
            this.entryPointBuilderByAuthority.put(missingAuthority, builder);
            return this;
        }

        public Builder addEntryPointFor(Consumer<DelegatingAuthenticationEntryPoint.Builder> entryPoint, String missingAuthority) {
            entryPoint.accept(this.entryPointBuilderByAuthority.computeIfAbsent(missingAuthority, k -> DelegatingAuthenticationEntryPoint.builder()));
            return this;
        }

        public DelegatingMissingAuthorityAccessDeniedHandler build() {
            LinkedHashMap<String, AuthenticationEntryPoint> entryPointByAuthority = new LinkedHashMap<String, AuthenticationEntryPoint>();
            this.entryPointBuilderByAuthority.forEach((key, value) -> entryPointByAuthority.put((String)key, value.build()));
            return new DelegatingMissingAuthorityAccessDeniedHandler(entryPointByAuthority);
        }
    }
}

