/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.management;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.ImmutablePublicKeyCredentialUserEntity;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialUserEntity;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialUserEntityRepository;
import org.springframework.util.Assert;

public final class JdbcPublicKeyCredentialUserEntityRepository
implements PublicKeyCredentialUserEntityRepository {
    private RowMapper<PublicKeyCredentialUserEntity> userEntityRowMapper = new UserEntityRecordRowMapper();
    private Function<PublicKeyCredentialUserEntity, List<SqlParameterValue>> userEntityParametersMapper = new UserEntityParametersMapper();
    private final JdbcOperations jdbcOperations;
    private static final String TABLE_NAME = "user_entities";
    private static final String COLUMN_NAMES = "id, name, display_name ";
    private static final String SAVE_USER_SQL = "INSERT INTO user_entities (id, name, display_name ) VALUES (?, ?, ?)";
    private static final String ID_FILTER = "id = ? ";
    private static final String USER_NAME_FILTER = "name = ? ";
    private static final String FIND_USER_BY_ID_SQL = "SELECT id, name, display_name  FROM user_entities WHERE id = ? ";
    private static final String FIND_USER_BY_NAME_SQL = "SELECT id, name, display_name  FROM user_entities WHERE name = ? ";
    private static final String DELETE_USER_SQL = "DELETE FROM user_entities WHERE id = ? ";
    private static final String UPDATE_USER_SQL = "UPDATE user_entities SET name = ?, display_name = ?  WHERE id = ? ";

    public JdbcPublicKeyCredentialUserEntityRepository(JdbcOperations jdbcOperations) {
        Assert.notNull((Object)jdbcOperations, (String)"jdbcOperations cannot be null");
        this.jdbcOperations = jdbcOperations;
    }

    @Override
    public PublicKeyCredentialUserEntity findById(Bytes id) {
        Assert.notNull((Object)id, (String)"id cannot be null");
        List result = this.jdbcOperations.query(FIND_USER_BY_ID_SQL, this.userEntityRowMapper, new Object[]{id.toBase64UrlString()});
        return !result.isEmpty() ? (PublicKeyCredentialUserEntity)result.get(0) : null;
    }

    @Override
    public PublicKeyCredentialUserEntity findByUsername(String username) {
        Assert.hasText((String)username, (String)"name cannot be null or empty");
        List result = this.jdbcOperations.query(FIND_USER_BY_NAME_SQL, this.userEntityRowMapper, new Object[]{username});
        return !result.isEmpty() ? (PublicKeyCredentialUserEntity)result.get(0) : null;
    }

    @Override
    public void save(PublicKeyCredentialUserEntity userEntity) {
        boolean existsUserEntity;
        Assert.notNull((Object)userEntity, (String)"userEntity cannot be null");
        boolean bl = existsUserEntity = null != this.findById(userEntity.getId());
        if (existsUserEntity) {
            this.updateUserEntity(userEntity);
        } else {
            try {
                this.insertUserEntity(userEntity);
            }
            catch (DuplicateKeyException ex) {
                this.updateUserEntity(userEntity);
            }
        }
    }

    private void insertUserEntity(PublicKeyCredentialUserEntity userEntity) {
        List<SqlParameterValue> parameters = this.userEntityParametersMapper.apply(userEntity);
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters.toArray());
        this.jdbcOperations.update(SAVE_USER_SQL, (PreparedStatementSetter)pss);
    }

    private void updateUserEntity(PublicKeyCredentialUserEntity userEntity) {
        List<SqlParameterValue> parameters = this.userEntityParametersMapper.apply(userEntity);
        SqlParameterValue userEntityId = parameters.remove(0);
        parameters.add(userEntityId);
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters.toArray());
        this.jdbcOperations.update(UPDATE_USER_SQL, (PreparedStatementSetter)pss);
    }

    @Override
    public void delete(Bytes id) {
        Assert.notNull((Object)id, (String)"id cannot be null");
        Object[] parameters = new SqlParameterValue[]{new SqlParameterValue(12, (Object)id.toBase64UrlString())};
        ArgumentPreparedStatementSetter pss = new ArgumentPreparedStatementSetter(parameters);
        this.jdbcOperations.update(DELETE_USER_SQL, (PreparedStatementSetter)pss);
    }

    private static class UserEntityRecordRowMapper
    implements RowMapper<PublicKeyCredentialUserEntity> {
        private UserEntityRecordRowMapper() {
        }

        public PublicKeyCredentialUserEntity mapRow(ResultSet rs, int rowNum) throws SQLException {
            Bytes id = Bytes.fromBase64(new String(rs.getString("id").getBytes()));
            String name = rs.getString("name");
            String displayName = rs.getString("display_name");
            return ImmutablePublicKeyCredentialUserEntity.builder().id(id).name(name).displayName(displayName).build();
        }
    }

    private static class UserEntityParametersMapper
    implements Function<PublicKeyCredentialUserEntity, List<SqlParameterValue>> {
        private UserEntityParametersMapper() {
        }

        @Override
        public List<SqlParameterValue> apply(PublicKeyCredentialUserEntity userEntity) {
            ArrayList<SqlParameterValue> parameters = new ArrayList<SqlParameterValue>();
            parameters.add(new SqlParameterValue(12, (Object)userEntity.getId().toBase64UrlString()));
            parameters.add(new SqlParameterValue(12, (Object)userEntity.getName()));
            parameters.add(new SqlParameterValue(12, (Object)userEntity.getDisplayName()));
            return parameters;
        }
    }
}

