/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util.matcher;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class AndRequestMatcher
implements RequestMatcher {
    private final List<RequestMatcher> requestMatchers;

    public AndRequestMatcher(List<RequestMatcher> requestMatchers) {
        Assert.notEmpty(requestMatchers, (String)"requestMatchers must contain a value");
        Assert.noNullElements(requestMatchers, (String)"requestMatchers cannot contain null values");
        this.requestMatchers = requestMatchers;
    }

    public AndRequestMatcher(RequestMatcher ... requestMatchers) {
        this(Arrays.asList(requestMatchers));
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        for (RequestMatcher matcher : this.requestMatchers) {
            if (matcher.matches(request)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        for (RequestMatcher matcher : this.requestMatchers) {
            RequestMatcher.MatchResult result = matcher.matcher(request);
            if (!result.isMatch()) {
                return RequestMatcher.MatchResult.notMatch();
            }
            variables.putAll(result.getVariables());
        }
        return RequestMatcher.MatchResult.match(variables);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndRequestMatcher that = (AndRequestMatcher)o;
        return Objects.equals(this.requestMatchers, that.requestMatchers);
    }

    public int hashCode() {
        return Objects.hash(this.requestMatchers);
    }

    public String toString() {
        return "And " + this.requestMatchers;
    }
}

