/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;

public final class RequestAttributeSecurityContextRepository
implements SecurityContextRepository {
    public static final String DEFAULT_REQUEST_ATTR_NAME = RequestAttributeSecurityContextRepository.class.getName().concat(".SPRING_SECURITY_CONTEXT");
    private final String requestAttributeName;

    public RequestAttributeSecurityContextRepository() {
        this(DEFAULT_REQUEST_ATTR_NAME);
    }

    public RequestAttributeSecurityContextRepository(String requestAttributeName) {
        this.requestAttributeName = requestAttributeName;
    }

    @Override
    public boolean containsContext(HttpServletRequest request) {
        return this.loadContext(request) != null;
    }

    @Override
    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        SecurityContext context = this.loadContext(requestResponseHolder.getRequest());
        return context != null ? context : SecurityContextHolder.createEmptyContext();
    }

    private SecurityContext loadContext(HttpServletRequest request) {
        return (SecurityContext)request.getAttribute(this.requestAttributeName);
    }

    @Override
    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute(this.requestAttributeName, (Object)context);
    }
}

