/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.util.matcher;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class NegatedServerWebExchangeMatcher
implements ServerWebExchangeMatcher {
    private static final Log logger = LogFactory.getLog(NegatedServerWebExchangeMatcher.class);
    private final ServerWebExchangeMatcher matcher;

    public NegatedServerWebExchangeMatcher(ServerWebExchangeMatcher matcher) {
        Assert.notNull((Object)matcher, (String)"matcher cannot be null");
        this.matcher = matcher;
    }

    @Override
    public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange) {
        return this.matcher.matches(exchange).flatMap(m -> m.isMatch() ? ServerWebExchangeMatcher.MatchResult.notMatch() : ServerWebExchangeMatcher.MatchResult.match()).doOnNext(it -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("matches = " + it.isMatch()));
            }
        });
    }

    public String toString() {
        return "NegatedServerWebExchangeMatcher{matcher=" + this.matcher + '}';
    }
}

