/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access.expression;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.expression.EvaluationContext;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.DelegatingEvaluationContext;
import org.springframework.security.web.access.expression.EvaluationContextPostProcessor;

abstract class AbstractVariableEvaluationContextPostProcessor
implements EvaluationContextPostProcessor<FilterInvocation> {
    AbstractVariableEvaluationContextPostProcessor() {
    }

    @Override
    public final EvaluationContext postProcess(EvaluationContext context, FilterInvocation invocation) {
        final HttpServletRequest request = invocation.getHttpRequest();
        return new DelegatingEvaluationContext(context){
            private Map<String, String> variables;

            @Override
            public Object lookupVariable(String name) {
                Object result = super.lookupVariable(name);
                if (result != null) {
                    return result;
                }
                if (this.variables == null) {
                    this.variables = AbstractVariableEvaluationContextPostProcessor.this.extractVariables(request);
                }
                name = AbstractVariableEvaluationContextPostProcessor.this.postProcessVariableName(name);
                return this.variables.get(name);
            }
        };
    }

    abstract Map<String, String> extractVariables(HttpServletRequest var1);

    abstract String postProcessVariableName(String var1);
}

