/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.servlet.response;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.test.web.support.WebTestUtils;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.util.Assert;

public final class SecurityMockMvcResultMatchers {
    private SecurityMockMvcResultMatchers() {
    }

    public static AuthenticatedMatcher authenticated() {
        return new AuthenticatedMatcher();
    }

    public static ResultMatcher unauthenticated() {
        return new UnAuthenticatedMatcher();
    }

    public static final class AuthenticatedMatcher
    extends AuthenticationMatcher<AuthenticatedMatcher> {
        private @Nullable SecurityContext expectedContext;
        private @Nullable Authentication expectedAuthentication;
        private @Nullable Object expectedAuthenticationPrincipal;
        private @Nullable String expectedAuthenticationName;
        private @Nullable Collection<? extends GrantedAuthority> expectedGrantedAuthorities;
        private @Nullable Collection<String> expectedAuthorities;
        private Predicate<GrantedAuthority> ignoreAuthorities = authority -> false;
        private @Nullable Consumer<Authentication> assertAuthentication;

        AuthenticatedMatcher() {
        }

        @NullUnmarked
        public void match(MvcResult result) {
            List<Object> authorities;
            SecurityContext context = this.load(result);
            Authentication auth = context.getAuthentication();
            AssertionErrors.assertTrue((String)"Authentication should not be null", (auth != null ? 1 : 0) != 0);
            if (this.assertAuthentication != null) {
                this.assertAuthentication.accept(auth);
            }
            if (this.expectedContext != null) {
                AssertionErrors.assertEquals((String)(String.valueOf(this.expectedContext) + " does not equal " + String.valueOf(context)), (Object)this.expectedContext, (Object)context);
            }
            if (this.expectedAuthentication != null) {
                AssertionErrors.assertEquals((String)(String.valueOf(this.expectedAuthentication) + " does not equal " + String.valueOf(context.getAuthentication())), (Object)this.expectedAuthentication, (Object)context.getAuthentication());
            }
            if (this.expectedAuthenticationPrincipal != null) {
                AssertionErrors.assertTrue((String)"Authentication cannot be null", (context.getAuthentication() != null ? 1 : 0) != 0);
                AssertionErrors.assertEquals((String)(String.valueOf(this.expectedAuthenticationPrincipal) + " does not equal " + String.valueOf(context.getAuthentication().getPrincipal())), (Object)this.expectedAuthenticationPrincipal, (Object)context.getAuthentication().getPrincipal());
            }
            if (this.expectedAuthenticationName != null) {
                AssertionErrors.assertTrue((String)"Authentication cannot be null", (auth != null ? 1 : 0) != 0);
                String name = auth.getName();
                AssertionErrors.assertEquals((String)(this.expectedAuthenticationName + " does not equal " + name), (Object)this.expectedAuthenticationName, (Object)name);
            }
            if (this.expectedGrantedAuthorities != null) {
                AssertionErrors.assertTrue((String)"Authentication cannot be null", (auth != null ? 1 : 0) != 0);
                authorities = new ArrayList<GrantedAuthority>(auth.getAuthorities());
                authorities.removeIf(this.ignoreAuthorities);
                AssertionErrors.assertTrue((String)(String.valueOf(authorities) + " does not contain the same authorities as " + String.valueOf(this.expectedGrantedAuthorities)), (boolean)authorities.containsAll(this.expectedGrantedAuthorities));
                AssertionErrors.assertTrue((String)(String.valueOf(this.expectedGrantedAuthorities) + " does not contain the same authorities as " + String.valueOf(authorities)), (boolean)this.expectedGrantedAuthorities.containsAll(authorities));
            }
            if (this.expectedAuthorities != null) {
                AssertionErrors.assertTrue((String)"Authentication cannot be null", (auth != null ? 1 : 0) != 0);
                authorities = auth.getAuthorities().stream().filter(Predicate.not(this.ignoreAuthorities)).map(GrantedAuthority::getAuthority).toList();
                AssertionErrors.assertTrue((String)(String.valueOf(authorities) + " does not contain the same authorities as " + String.valueOf(this.expectedAuthorities)), (boolean)this.expectedAuthorities.containsAll(authorities));
                AssertionErrors.assertTrue((String)(String.valueOf(this.expectedAuthorities) + " does not contain the same authorities as " + String.valueOf(authorities)), (boolean)authorities.containsAll(this.expectedAuthorities));
            }
        }

        public AuthenticatedMatcher withAuthentication(Consumer<Authentication> assertAuthentication) {
            this.assertAuthentication = assertAuthentication;
            return this;
        }

        public AuthenticatedMatcher withUsername(String expected) {
            return this.withAuthenticationName(expected);
        }

        public AuthenticatedMatcher withSecurityContext(SecurityContext expected) {
            this.expectedContext = expected;
            return this;
        }

        public AuthenticatedMatcher withAuthentication(Authentication expected) {
            this.expectedAuthentication = expected;
            return this;
        }

        public AuthenticatedMatcher withAuthenticationPrincipal(Object expected) {
            this.expectedAuthenticationPrincipal = expected;
            return this;
        }

        public AuthenticatedMatcher withAuthenticationName(String expected) {
            this.expectedAuthenticationName = expected;
            return this;
        }

        public AuthenticatedMatcher withAuthorities(String ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.expectedAuthorities = Arrays.asList(authorities);
            return this;
        }

        public AuthenticatedMatcher withAuthorities(Collection<? extends GrantedAuthority> expected) {
            this.expectedGrantedAuthorities = expected;
            return this;
        }

        public AuthenticatedMatcher withRoles(String ... roles) {
            return this.withRoles("ROLE_", roles);
        }

        public AuthenticatedMatcher withRoles(String rolePrefix, String[] roles) {
            ArrayList<SimpleGrantedAuthority> withPrefix = new ArrayList<SimpleGrantedAuthority>();
            for (String role : roles) {
                withPrefix.add(new SimpleGrantedAuthority(rolePrefix + role));
            }
            this.ignoreAuthorities = authority -> !authority.getAuthority().startsWith(rolePrefix);
            return this.withAuthorities(withPrefix);
        }
    }

    private static final class UnAuthenticatedMatcher
    extends AuthenticationMatcher<UnAuthenticatedMatcher> {
        private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

        private UnAuthenticatedMatcher() {
        }

        public void match(MvcResult result) {
            SecurityContext context = this.load(result);
            Authentication authentication = context.getAuthentication();
            AssertionErrors.assertTrue((String)("Expected anonymous Authentication got " + String.valueOf(context)), (authentication == null || this.trustResolver.isAnonymous(authentication) ? 1 : 0) != 0);
        }
    }

    private static abstract class AuthenticationMatcher<T extends AuthenticationMatcher<T>>
    implements ResultMatcher {
        private AuthenticationMatcher() {
        }

        protected SecurityContext load(MvcResult result) {
            HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)result.getRequest(), (HttpServletResponse)result.getResponse());
            SecurityContextRepository repository = WebTestUtils.getSecurityContextRepository((HttpServletRequest)result.getRequest());
            return repository.loadContext(holder);
        }
    }
}

