/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.servlet.setup;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurerAdapter;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

final class SecurityMockMvcConfigurer
extends MockMvcConfigurerAdapter {
    private final DelegateFilter delegateFilter;

    SecurityMockMvcConfigurer() {
        this.delegateFilter = new DelegateFilter();
    }

    SecurityMockMvcConfigurer(Filter springSecurityFilterChain) {
        this.delegateFilter = new DelegateFilter(springSecurityFilterChain);
    }

    public void afterConfigurerAdded(ConfigurableMockMvcBuilder<?> builder) {
        builder.addFilters(new Filter[]{this.delegateFilter});
    }

    public RequestPostProcessor beforeMockMvcCreated(ConfigurableMockMvcBuilder<?> builder, WebApplicationContext context) {
        String securityBeanId = "springSecurityFilterChain";
        if (this.getSpringSecurityFilterChain() == null && context.containsBean(securityBeanId)) {
            this.setSpringSecurityFitlerChain((Filter)context.getBean(securityBeanId, Filter.class));
        }
        Assert.state((this.getSpringSecurityFilterChain() != null ? 1 : 0) != 0, () -> "springSecurityFilterChain cannot be null. Ensure a Bean with the name " + securityBeanId + " implementing Filter is present or inject the Filter to be used.");
        context.getServletContext().setAttribute("springSecurityFilterChain", (Object)this.getSpringSecurityFilterChain());
        return SecurityMockMvcRequestPostProcessors.testSecurityContext();
    }

    private void setSpringSecurityFitlerChain(Filter filter) {
        this.delegateFilter.setDelegate(filter);
    }

    private Filter getSpringSecurityFilterChain() {
        return this.delegateFilter.delegate;
    }

    static class DelegateFilter
    implements Filter {
        private Filter delegate;

        DelegateFilter() {
        }

        DelegateFilter(Filter delegate) {
            this.delegate = delegate;
        }

        void setDelegate(Filter delegate) {
            this.delegate = delegate;
        }

        Filter getDelegate() {
            Filter result = this.delegate;
            Assert.state((result != null ? 1 : 0) != 0, () -> "delegate cannot be null. Ensure a Bean with the name springSecurityFilterChain implementing Filter is present or inject the Filter to be used.");
            return result;
        }

        public void init(FilterConfig filterConfig) throws ServletException {
            this.getDelegate().init(filterConfig);
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            this.getDelegate().doFilter(request, response, chain);
        }

        public void destroy() {
            this.getDelegate().destroy();
        }

        public boolean equals(Object obj) {
            return this.getDelegate().equals(obj);
        }

        public int hashCode() {
            return this.getDelegate().hashCode();
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }
}

