/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.web.servlet.request;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.method.annotation.OAuth2AuthorizedClientArgumentResolver;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.test.context.TestSecurityContextHolderStrategyAdapter;
import org.springframework.security.test.web.support.WebTestUtils;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public final class SecurityMockMvcRequestPostProcessors {
    private static final SecurityContextHolderStrategy DEFAULT_SECURITY_CONTEXT_HOLDER_STRATEGY = new TestSecurityContextHolderStrategyAdapter();

    private SecurityMockMvcRequestPostProcessors() {
    }

    public static DigestRequestPostProcessor digest() {
        return new DigestRequestPostProcessor();
    }

    public static DigestRequestPostProcessor digest(String username) {
        return SecurityMockMvcRequestPostProcessors.digest().username(username);
    }

    public static RequestPostProcessor x509(X509Certificate ... certificates) {
        return new X509RequestPostProcessor(certificates);
    }

    public static RequestPostProcessor x509(String resourceName) throws IOException, CertificateException {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(resourceName);
        InputStream inputStream = resource.getInputStream();
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)certFactory.generateCertificate(inputStream);
        return SecurityMockMvcRequestPostProcessors.x509(certificate);
    }

    public static CsrfRequestPostProcessor csrf() {
        return new CsrfRequestPostProcessor();
    }

    public static RequestPostProcessor testSecurityContext() {
        return new TestSecurityContextHolderPostProcessor();
    }

    public static UserRequestPostProcessor user(String username) {
        return new UserRequestPostProcessor(username);
    }

    public static RequestPostProcessor user(UserDetails user) {
        return new UserDetailsRequestPostProcessor(user);
    }

    public static JwtRequestPostProcessor jwt() {
        return new JwtRequestPostProcessor();
    }

    public static OpaqueTokenRequestPostProcessor opaqueToken() {
        return new OpaqueTokenRequestPostProcessor();
    }

    public static RequestPostProcessor authentication(Authentication authentication) {
        return new AuthenticationRequestPostProcessor(authentication);
    }

    public static RequestPostProcessor anonymous() {
        return new AnonymousRequestPostProcessor();
    }

    public static RequestPostProcessor securityContext(SecurityContext securityContext) {
        return new SecurityContextRequestPostProcessor(securityContext);
    }

    public static RequestPostProcessor httpBasic(String username, String password) {
        return new HttpBasicRequestPostProcessor(username, password);
    }

    public static OAuth2LoginRequestPostProcessor oauth2Login() {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "access-token", null, null, Collections.singleton("read"));
        return new OAuth2LoginRequestPostProcessor(accessToken);
    }

    public static OidcLoginRequestPostProcessor oidcLogin() {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "access-token", null, null, Collections.singleton("read"));
        return new OidcLoginRequestPostProcessor(accessToken);
    }

    public static OAuth2ClientRequestPostProcessor oauth2Client() {
        return new OAuth2ClientRequestPostProcessor();
    }

    public static OAuth2ClientRequestPostProcessor oauth2Client(String registrationId) {
        return new OAuth2ClientRequestPostProcessor(registrationId);
    }

    private static SecurityContextHolderStrategy getSecurityContextHolderStrategy(HttpServletRequest request) {
        WebApplicationContext context = WebApplicationContextUtils.findWebApplicationContext((ServletContext)request.getServletContext());
        if (context == null) {
            return DEFAULT_SECURITY_CONTEXT_HOLDER_STRATEGY;
        }
        if (context.getBeanNamesForType(SecurityContextHolderStrategy.class).length == 0) {
            return DEFAULT_SECURITY_CONTEXT_HOLDER_STRATEGY;
        }
        return (SecurityContextHolderStrategy)context.getBean(SecurityContextHolderStrategy.class);
    }

    public static class DigestRequestPostProcessor
    implements RequestPostProcessor {
        private String username = "user";
        private String password = "password";
        private String realm = "Spring Security";
        private String nonce = DigestRequestPostProcessor.generateNonce(60);
        private String qop = "auth";
        private String nc = "00000001";
        private String cnonce = "c822c727a648aba7";

        private DigestRequestPostProcessor username(String username) {
            Assert.notNull((Object)username, (String)"username cannot be null");
            this.username = username;
            return this;
        }

        public DigestRequestPostProcessor password(String password) {
            Assert.notNull((Object)password, (String)"password cannot be null");
            this.password = password;
            return this;
        }

        public DigestRequestPostProcessor realm(String realm) {
            Assert.notNull((Object)realm, (String)"realm cannot be null");
            this.realm = realm;
            return this;
        }

        private static String generateNonce(int validitySeconds) {
            long expiryTime = System.currentTimeMillis() + (long)(validitySeconds * 1000);
            String toDigest = expiryTime + ":key";
            String signatureValue = DigestRequestPostProcessor.md5Hex(toDigest);
            String nonceValue = expiryTime + ":" + signatureValue;
            return new String(Base64.getEncoder().encode(nonceValue.getBytes()));
        }

        private String createAuthorizationHeader(MockHttpServletRequest request) {
            String uri = request.getRequestURI();
            String responseDigest = DigestRequestPostProcessor.generateDigest(this.username, this.realm, this.password, request.getMethod(), uri, this.qop, this.nonce, this.nc, this.cnonce);
            return "Digest username=\"" + this.username + "\", realm=\"" + this.realm + "\", nonce=\"" + this.nonce + "\", uri=\"" + uri + "\", response=\"" + responseDigest + "\", qop=" + this.qop + ", nc=" + this.nc + ", cnonce=\"" + this.cnonce + "\"";
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            request.addHeader("Authorization", (Object)this.createAuthorizationHeader(request));
            return request;
        }

        private static String generateDigest(String username, String realm, String password, String httpMethod, String uri, String qop, String nonce, String nc, String cnonce) throws IllegalArgumentException {
            String a1Md5 = DigestRequestPostProcessor.encodePasswordInA1Format(username, realm, password);
            String a2 = httpMethod + ":" + uri;
            String a2Md5 = DigestRequestPostProcessor.md5Hex(a2);
            if (qop == null) {
                return DigestRequestPostProcessor.md5Hex(a1Md5 + ":" + nonce + ":" + a2Md5);
            }
            if ("auth".equals(qop)) {
                return DigestRequestPostProcessor.md5Hex(a1Md5 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + a2Md5);
            }
            throw new IllegalArgumentException("This method does not support a qop: '" + qop + "'");
        }

        static String encodePasswordInA1Format(String username, String realm, String password) {
            return DigestRequestPostProcessor.md5Hex(username + ":" + realm + ":" + password);
        }

        private static String md5Hex(String a2) {
            return DigestUtils.md5DigestAsHex((byte[])a2.getBytes(StandardCharsets.UTF_8));
        }
    }

    private static final class X509RequestPostProcessor
    implements RequestPostProcessor {
        private final X509Certificate[] certificates;

        private X509RequestPostProcessor(X509Certificate ... certificates) {
            Assert.notNull((Object)certificates, (String)"X509Certificate cannot be null");
            this.certificates = certificates;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            request.setAttribute("jakarta.servlet.request.X509Certificate", (Object)this.certificates);
            return request;
        }
    }

    public static final class CsrfRequestPostProcessor
    implements RequestPostProcessor {
        private boolean asHeader;
        private boolean useInvalidToken;

        private CsrfRequestPostProcessor() {
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            Object tokenValue;
            CsrfTokenRepository repository = WebTestUtils.getCsrfTokenRepository((HttpServletRequest)request);
            if (!(repository instanceof TestCsrfTokenRepository)) {
                repository = new TestCsrfTokenRepository((CsrfTokenRepository)new HttpSessionCsrfTokenRepository());
                WebTestUtils.setCsrfTokenRepository((HttpServletRequest)request, repository);
            }
            TestCsrfTokenRepository.enable((HttpServletRequest)request);
            CsrfToken token = repository.generateToken((HttpServletRequest)request);
            repository.saveToken(token, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
            Object object = tokenValue = this.useInvalidToken ? "invalid" + token.getToken() : token.getToken();
            if (this.asHeader) {
                request.addHeader(token.getHeaderName(), tokenValue);
            } else {
                request.setParameter(token.getParameterName(), (String)tokenValue);
            }
            return request;
        }

        public CsrfRequestPostProcessor asHeader() {
            this.asHeader = true;
            return this;
        }

        public CsrfRequestPostProcessor useInvalidToken() {
            this.useInvalidToken = true;
            return this;
        }

        static class TestCsrfTokenRepository
        implements CsrfTokenRepository {
            static final String TOKEN_ATTR_NAME = TestCsrfTokenRepository.class.getName().concat(".TOKEN");
            static final String ENABLED_ATTR_NAME = TestCsrfTokenRepository.class.getName().concat(".ENABLED");
            private final CsrfTokenRepository delegate;

            TestCsrfTokenRepository(CsrfTokenRepository delegate) {
                this.delegate = delegate;
            }

            public CsrfToken generateToken(HttpServletRequest request) {
                return this.delegate.generateToken(request);
            }

            public void saveToken(CsrfToken token, HttpServletRequest request, HttpServletResponse response) {
                if (this.isEnabled(request)) {
                    request.setAttribute(TOKEN_ATTR_NAME, (Object)token);
                } else {
                    this.delegate.saveToken(token, request, response);
                }
            }

            public CsrfToken loadToken(HttpServletRequest request) {
                if (this.isEnabled(request)) {
                    return (CsrfToken)request.getAttribute(TOKEN_ATTR_NAME);
                }
                return this.delegate.loadToken(request);
            }

            static void enable(HttpServletRequest request) {
                request.setAttribute(ENABLED_ATTR_NAME, (Object)Boolean.TRUE);
            }

            boolean isEnabled(HttpServletRequest request) {
                return Boolean.TRUE.equals(request.getAttribute(ENABLED_ATTR_NAME));
            }
        }
    }

    private static final class TestSecurityContextHolderPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private TestSecurityContextHolderPostProcessor() {
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            SecurityContext context;
            SecurityContext existingContext = SecurityContextRequestPostProcessorSupport.TestSecurityContextRepository.getContext((HttpServletRequest)request);
            if (existingContext != null) {
                return request;
            }
            SecurityContextHolderStrategy strategy = SecurityMockMvcRequestPostProcessors.getSecurityContextHolderStrategy((HttpServletRequest)request);
            SecurityContext empty = strategy.createEmptyContext();
            if (!empty.equals(context = strategy.getContext())) {
                this.save(context, (HttpServletRequest)request);
            }
            return request;
        }
    }

    public static final class UserRequestPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private String username;
        private String password = "password";
        private static final String ROLE_PREFIX = "ROLE_";
        private Collection<? extends GrantedAuthority> authorities = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"});
        private boolean enabled = true;
        private boolean accountNonExpired = true;
        private boolean credentialsNonExpired = true;
        private boolean accountNonLocked = true;

        private UserRequestPostProcessor(String username) {
            Assert.notNull((Object)username, (String)"username cannot be null");
            this.username = username;
        }

        public UserRequestPostProcessor roles(String ... roles) {
            ArrayList<? extends GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(roles.length);
            for (String role : roles) {
                Assert.isTrue((!role.startsWith(ROLE_PREFIX) ? 1 : 0) != 0, () -> "Role should not start with ROLE_ since this method automatically prefixes with this value. Got " + role);
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority(ROLE_PREFIX + role));
            }
            this.authorities = authorities;
            return this;
        }

        public UserRequestPostProcessor authorities(GrantedAuthority ... authorities) {
            return this.authorities(Arrays.asList(authorities));
        }

        public UserRequestPostProcessor authorities(Collection<? extends GrantedAuthority> authorities) {
            this.authorities = authorities;
            return this;
        }

        public UserRequestPostProcessor password(String password) {
            this.password = password;
            return this;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            UserDetailsRequestPostProcessor delegate = new UserDetailsRequestPostProcessor((UserDetails)this.createUser());
            return delegate.postProcessRequest(request);
        }

        private User createUser() {
            return new User(this.username, this.password, this.enabled, this.accountNonExpired, this.credentialsNonExpired, this.accountNonLocked, this.authorities);
        }
    }

    private static final class UserDetailsRequestPostProcessor
    implements RequestPostProcessor {
        private final AuthenticationRequestPostProcessor delegate;

        UserDetailsRequestPostProcessor(UserDetails user) {
            UsernamePasswordAuthenticationToken token = UsernamePasswordAuthenticationToken.authenticated((Object)user, (Object)user.getPassword(), (Collection)user.getAuthorities());
            this.delegate = new AuthenticationRequestPostProcessor((Authentication)token);
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            return this.delegate.postProcessRequest(request);
        }
    }

    public static final class JwtRequestPostProcessor
    implements RequestPostProcessor {
        private Jwt jwt;
        private Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter = new JwtGrantedAuthoritiesConverter();

        private JwtRequestPostProcessor() {
            this.jwt((Jwt.Builder jwt) -> {});
        }

        public JwtRequestPostProcessor jwt(Consumer<Jwt.Builder> jwtBuilderConsumer) {
            Jwt.Builder jwtBuilder = Jwt.withTokenValue((String)"token").header("alg", (Object)"none").claim("sub", (Object)"user").claim("scope", (Object)"read");
            jwtBuilderConsumer.accept(jwtBuilder);
            this.jwt = jwtBuilder.build();
            return this;
        }

        public JwtRequestPostProcessor jwt(Jwt jwt) {
            this.jwt = jwt;
            return this;
        }

        public JwtRequestPostProcessor authorities(Collection<GrantedAuthority> authorities) {
            Assert.notNull(authorities, (String)"authorities cannot be null");
            this.authoritiesConverter = jwt -> authorities;
            return this;
        }

        public JwtRequestPostProcessor authorities(GrantedAuthority ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.authoritiesConverter = jwt -> Arrays.asList(authorities);
            return this;
        }

        public JwtRequestPostProcessor authorities(Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter) {
            Assert.notNull(authoritiesConverter, (String)"authoritiesConverter cannot be null");
            this.authoritiesConverter = authoritiesConverter;
            return this;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            CsrfFilter.skipRequest((HttpServletRequest)request);
            JwtAuthenticationToken token = new JwtAuthenticationToken(this.jwt, (Collection)this.authoritiesConverter.convert((Object)this.jwt));
            return new AuthenticationRequestPostProcessor((Authentication)token).postProcessRequest(request);
        }
    }

    public static final class OpaqueTokenRequestPostProcessor
    implements RequestPostProcessor {
        private Supplier<Map<String, Object>> attributes = this::defaultAttributes;
        private Supplier<Collection<GrantedAuthority>> authorities = this::defaultAuthorities;
        private Supplier<OAuth2AuthenticatedPrincipal> principal = this::defaultPrincipal;

        private OpaqueTokenRequestPostProcessor() {
        }

        public OpaqueTokenRequestPostProcessor attributes(Consumer<Map<String, Object>> attributesConsumer) {
            Assert.notNull(attributesConsumer, (String)"attributesConsumer cannot be null");
            this.attributes = () -> {
                Map<String, Object> attributes = this.defaultAttributes();
                attributesConsumer.accept(attributes);
                return attributes;
            };
            this.principal = this::defaultPrincipal;
            return this;
        }

        public OpaqueTokenRequestPostProcessor authorities(Collection<GrantedAuthority> authorities) {
            Assert.notNull(authorities, (String)"authorities cannot be null");
            this.authorities = () -> authorities;
            this.principal = this::defaultPrincipal;
            return this;
        }

        public OpaqueTokenRequestPostProcessor authorities(GrantedAuthority ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.authorities = () -> Arrays.asList(authorities);
            this.principal = this::defaultPrincipal;
            return this;
        }

        public OpaqueTokenRequestPostProcessor principal(OAuth2AuthenticatedPrincipal principal) {
            Assert.notNull((Object)principal, (String)"principal cannot be null");
            this.principal = () -> principal;
            return this;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            CsrfFilter.skipRequest((HttpServletRequest)request);
            OAuth2AuthenticatedPrincipal principal = this.principal.get();
            OAuth2AccessToken accessToken = this.getOAuth2AccessToken(principal);
            BearerTokenAuthentication token = new BearerTokenAuthentication(principal, accessToken, principal.getAuthorities());
            return new AuthenticationRequestPostProcessor((Authentication)token).postProcessRequest(request);
        }

        private Map<String, Object> defaultAttributes() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("sub", "user");
            attributes.put("scope", "read");
            return attributes;
        }

        private Collection<GrantedAuthority> defaultAuthorities() {
            Map<String, Object> attributes = this.attributes.get();
            Object scope = attributes.get("scope");
            if (scope == null) {
                return Collections.emptyList();
            }
            if (scope instanceof Collection) {
                return this.getAuthorities((Collection)scope);
            }
            String scopes = scope.toString();
            if (!StringUtils.hasText((String)scopes)) {
                return Collections.emptyList();
            }
            return this.getAuthorities(Arrays.asList(scopes.split(" ")));
        }

        private OAuth2AuthenticatedPrincipal defaultPrincipal() {
            return new OAuth2IntrospectionAuthenticatedPrincipal(this.attributes.get(), this.authorities.get());
        }

        private Collection<GrantedAuthority> getAuthorities(Collection<?> scopes) {
            return scopes.stream().map(scope -> new SimpleGrantedAuthority("SCOPE_" + scope)).collect(Collectors.toList());
        }

        private OAuth2AccessToken getOAuth2AccessToken(OAuth2AuthenticatedPrincipal principal) {
            Instant expiresAt = this.getInstant(principal.getAttributes(), "exp");
            Instant issuedAt = this.getInstant(principal.getAttributes(), "iat");
            return new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "token", issuedAt, expiresAt);
        }

        private Instant getInstant(Map<String, Object> attributes, String name) {
            Object value = attributes.get(name);
            if (value == null) {
                return null;
            }
            if (value instanceof Instant) {
                return (Instant)value;
            }
            throw new IllegalArgumentException(name + " attribute must be of type Instant");
        }
    }

    private static final class AuthenticationRequestPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private final Authentication authentication;

        private AuthenticationRequestPostProcessor(Authentication authentication) {
            this.authentication = authentication;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            SecurityContext context = SecurityMockMvcRequestPostProcessors.getSecurityContextHolderStrategy((HttpServletRequest)request).createEmptyContext();
            context.setAuthentication(this.authentication);
            this.save(this.authentication, (HttpServletRequest)request);
            return request;
        }
    }

    private static class AnonymousRequestPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private AuthenticationRequestPostProcessor delegate = new AuthenticationRequestPostProcessor((Authentication)new AnonymousAuthenticationToken("key", (Object)"anonymous", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"})));

        private AnonymousRequestPostProcessor() {
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            return this.delegate.postProcessRequest(request);
        }
    }

    private static final class SecurityContextRequestPostProcessor
    extends SecurityContextRequestPostProcessorSupport
    implements RequestPostProcessor {
        private final SecurityContext securityContext;

        private SecurityContextRequestPostProcessor(SecurityContext securityContext) {
            this.securityContext = securityContext;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            this.save(this.securityContext, (HttpServletRequest)request);
            return request;
        }
    }

    private static final class HttpBasicRequestPostProcessor
    implements RequestPostProcessor {
        private String headerValue;

        private HttpBasicRequestPostProcessor(String username, String password) {
            byte[] toEncode = (username + ":" + password).getBytes(StandardCharsets.UTF_8);
            this.headerValue = "Basic " + new String(Base64.getEncoder().encode(toEncode));
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            request.addHeader("Authorization", (Object)this.headerValue);
            return request;
        }
    }

    public static final class OAuth2LoginRequestPostProcessor
    implements RequestPostProcessor {
        private final String nameAttributeKey = "sub";
        private ClientRegistration clientRegistration;
        private OAuth2AccessToken accessToken;
        private Supplier<Collection<GrantedAuthority>> authorities = this::defaultAuthorities;
        private Supplier<Map<String, Object>> attributes = this::defaultAttributes;
        private Supplier<OAuth2User> oauth2User = this::defaultPrincipal;

        private OAuth2LoginRequestPostProcessor(OAuth2AccessToken accessToken) {
            this.accessToken = accessToken;
            this.clientRegistration = this.clientRegistrationBuilder().build();
        }

        public OAuth2LoginRequestPostProcessor authorities(Collection<GrantedAuthority> authorities) {
            Assert.notNull(authorities, (String)"authorities cannot be null");
            this.authorities = () -> authorities;
            this.oauth2User = this::defaultPrincipal;
            return this;
        }

        public OAuth2LoginRequestPostProcessor authorities(GrantedAuthority ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.authorities = () -> Arrays.asList(authorities);
            this.oauth2User = this::defaultPrincipal;
            return this;
        }

        public OAuth2LoginRequestPostProcessor attributes(Consumer<Map<String, Object>> attributesConsumer) {
            Assert.notNull(attributesConsumer, (String)"attributesConsumer cannot be null");
            this.attributes = () -> {
                Map<String, Object> attributes = this.defaultAttributes();
                attributesConsumer.accept(attributes);
                return attributes;
            };
            this.oauth2User = this::defaultPrincipal;
            return this;
        }

        public OAuth2LoginRequestPostProcessor oauth2User(OAuth2User oauth2User) {
            this.oauth2User = () -> oauth2User;
            return this;
        }

        public OAuth2LoginRequestPostProcessor clientRegistration(ClientRegistration clientRegistration) {
            this.clientRegistration = clientRegistration;
            return this;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            OAuth2User oauth2User = this.oauth2User.get();
            OAuth2AuthenticationToken token = new OAuth2AuthenticationToken(oauth2User, oauth2User.getAuthorities(), this.clientRegistration.getRegistrationId());
            request = new AuthenticationRequestPostProcessor((Authentication)token).postProcessRequest(request);
            return new OAuth2ClientRequestPostProcessor().clientRegistration(this.clientRegistration).principalName(oauth2User.getName()).accessToken(this.accessToken).postProcessRequest(request);
        }

        private ClientRegistration.Builder clientRegistrationBuilder() {
            return ClientRegistration.withRegistrationId((String)"test").authorizationGrantType(AuthorizationGrantType.PASSWORD).clientId("test-client").tokenUri("https://token-uri.example.org");
        }

        private Collection<GrantedAuthority> defaultAuthorities() {
            LinkedHashSet<GrantedAuthority> authorities = new LinkedHashSet<GrantedAuthority>();
            authorities.add((GrantedAuthority)new OAuth2UserAuthority(this.attributes.get()));
            for (String authority : this.accessToken.getScopes()) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("SCOPE_" + authority));
            }
            return authorities;
        }

        private Map<String, Object> defaultAttributes() {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put(this.nameAttributeKey, "user");
            return attributes;
        }

        private OAuth2User defaultPrincipal() {
            return new DefaultOAuth2User(this.authorities.get(), this.attributes.get(), this.nameAttributeKey);
        }
    }

    public static final class OidcLoginRequestPostProcessor
    implements RequestPostProcessor {
        private ClientRegistration clientRegistration;
        private OAuth2AccessToken accessToken;
        private OidcIdToken idToken;
        private OidcUserInfo userInfo;
        private Supplier<OidcUser> oidcUser = this::defaultPrincipal;
        private Collection<GrantedAuthority> authorities;

        private OidcLoginRequestPostProcessor(OAuth2AccessToken accessToken) {
            this.accessToken = accessToken;
            this.clientRegistration = this.clientRegistrationBuilder().build();
        }

        public OidcLoginRequestPostProcessor authorities(Collection<GrantedAuthority> authorities) {
            Assert.notNull(authorities, (String)"authorities cannot be null");
            this.authorities = authorities;
            this.oidcUser = this::defaultPrincipal;
            return this;
        }

        public OidcLoginRequestPostProcessor authorities(GrantedAuthority ... authorities) {
            Assert.notNull((Object)authorities, (String)"authorities cannot be null");
            this.authorities = Arrays.asList(authorities);
            this.oidcUser = this::defaultPrincipal;
            return this;
        }

        public OidcLoginRequestPostProcessor idToken(Consumer<OidcIdToken.Builder> idTokenBuilderConsumer) {
            OidcIdToken.Builder builder = OidcIdToken.withTokenValue((String)"id-token");
            builder.subject("user");
            idTokenBuilderConsumer.accept(builder);
            this.idToken = builder.build();
            this.oidcUser = this::defaultPrincipal;
            return this;
        }

        public OidcLoginRequestPostProcessor userInfoToken(Consumer<OidcUserInfo.Builder> userInfoBuilderConsumer) {
            OidcUserInfo.Builder builder = OidcUserInfo.builder();
            userInfoBuilderConsumer.accept(builder);
            this.userInfo = builder.build();
            this.oidcUser = this::defaultPrincipal;
            return this;
        }

        public OidcLoginRequestPostProcessor oidcUser(OidcUser oidcUser) {
            this.oidcUser = () -> oidcUser;
            return this;
        }

        public OidcLoginRequestPostProcessor clientRegistration(ClientRegistration clientRegistration) {
            this.clientRegistration = clientRegistration;
            return this;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            OidcUser oidcUser = this.oidcUser.get();
            return new OAuth2LoginRequestPostProcessor(this.accessToken).oauth2User((OAuth2User)oidcUser).clientRegistration(this.clientRegistration).postProcessRequest(request);
        }

        private ClientRegistration.Builder clientRegistrationBuilder() {
            return ClientRegistration.withRegistrationId((String)"test").authorizationGrantType(AuthorizationGrantType.PASSWORD).clientId("test-client").tokenUri("https://token-uri.example.org");
        }

        private Collection<GrantedAuthority> getAuthorities() {
            if (this.authorities != null) {
                return this.authorities;
            }
            LinkedHashSet<GrantedAuthority> authorities = new LinkedHashSet<GrantedAuthority>();
            authorities.add((GrantedAuthority)new OidcUserAuthority(this.getOidcIdToken(), this.getOidcUserInfo()));
            for (String authority : this.accessToken.getScopes()) {
                authorities.add((GrantedAuthority)new SimpleGrantedAuthority("SCOPE_" + authority));
            }
            return authorities;
        }

        private OidcIdToken getOidcIdToken() {
            if (this.idToken != null) {
                return this.idToken;
            }
            return new OidcIdToken("id-token", null, null, Collections.singletonMap("sub", "user"));
        }

        private OidcUserInfo getOidcUserInfo() {
            return this.userInfo;
        }

        private OidcUser defaultPrincipal() {
            return new DefaultOidcUser(this.getAuthorities(), this.getOidcIdToken(), this.userInfo);
        }
    }

    public static final class OAuth2ClientRequestPostProcessor
    implements RequestPostProcessor {
        private String registrationId = "test";
        private ClientRegistration clientRegistration;
        private String principalName = "user";
        private OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, "access-token", null, null, Collections.singleton("read"));

        private OAuth2ClientRequestPostProcessor() {
        }

        private OAuth2ClientRequestPostProcessor(String registrationId) {
            this.registrationId = registrationId;
            this.clientRegistration((ClientRegistration.Builder c) -> {});
        }

        public OAuth2ClientRequestPostProcessor clientRegistration(ClientRegistration clientRegistration) {
            this.clientRegistration = clientRegistration;
            return this;
        }

        public OAuth2ClientRequestPostProcessor clientRegistration(Consumer<ClientRegistration.Builder> clientRegistrationConfigurer) {
            ClientRegistration.Builder builder = this.clientRegistrationBuilder();
            clientRegistrationConfigurer.accept(builder);
            this.clientRegistration = builder.build();
            return this;
        }

        public OAuth2ClientRequestPostProcessor principalName(String principalName) {
            Assert.notNull((Object)principalName, (String)"principalName cannot be null");
            this.principalName = principalName;
            return this;
        }

        public OAuth2ClientRequestPostProcessor accessToken(OAuth2AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
            if (this.clientRegistration == null) {
                throw new IllegalArgumentException("Please specify a ClientRegistration via one of the clientRegistration methods");
            }
            OAuth2AuthorizedClient client = new OAuth2AuthorizedClient(this.clientRegistration, this.principalName, this.accessToken);
            OAuth2AuthorizedClientManager authorizationClientManager = OAuth2ClientServletTestUtils.getOAuth2AuthorizedClientManager((HttpServletRequest)request);
            if (!(authorizationClientManager instanceof TestOAuth2AuthorizedClientManager)) {
                authorizationClientManager = new TestOAuth2AuthorizedClientManager(authorizationClientManager);
                OAuth2ClientServletTestUtils.setOAuth2AuthorizedClientManager((HttpServletRequest)request, authorizationClientManager);
            }
            TestOAuth2AuthorizedClientManager.enable((HttpServletRequest)request);
            request.setAttribute(TestOAuth2AuthorizedClientManager.TOKEN_ATTR_NAME, (Object)client);
            return request;
        }

        private ClientRegistration.Builder clientRegistrationBuilder() {
            return ClientRegistration.withRegistrationId((String)this.registrationId).authorizationGrantType(AuthorizationGrantType.PASSWORD).clientId("test-client").clientSecret("test-secret").tokenUri("https://idp.example.org/oauth/token");
        }

        private static final class OAuth2ClientServletTestUtils {
            private static final OAuth2AuthorizedClientRepository DEFAULT_CLIENT_REPO = new HttpSessionOAuth2AuthorizedClientRepository();

            private OAuth2ClientServletTestUtils() {
            }

            static OAuth2AuthorizedClientManager getOAuth2AuthorizedClientManager(HttpServletRequest request) {
                OAuth2AuthorizedClientArgumentResolver resolver = OAuth2ClientServletTestUtils.findResolver(request, OAuth2AuthorizedClientArgumentResolver.class);
                if (resolver == null) {
                    return authorizeRequest -> DEFAULT_CLIENT_REPO.loadAuthorizedClient(authorizeRequest.getClientRegistrationId(), authorizeRequest.getPrincipal(), request);
                }
                return (OAuth2AuthorizedClientManager)ReflectionTestUtils.getField((Object)resolver, (String)"authorizedClientManager");
            }

            static void setOAuth2AuthorizedClientManager(HttpServletRequest request, OAuth2AuthorizedClientManager manager) {
                OAuth2AuthorizedClientArgumentResolver resolver = OAuth2ClientServletTestUtils.findResolver(request, OAuth2AuthorizedClientArgumentResolver.class);
                if (resolver == null) {
                    return;
                }
                ReflectionTestUtils.setField((Object)resolver, (String)"authorizedClientManager", (Object)manager);
            }

            static <T extends HandlerMethodArgumentResolver> T findResolver(HttpServletRequest request, Class<T> resolverClass) {
                if (!ClassUtils.isPresent((String)"org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter", null)) {
                    return null;
                }
                return WebMvcClasspathGuard.findResolver(request, resolverClass);
            }

            private static class WebMvcClasspathGuard {
                private WebMvcClasspathGuard() {
                }

                static <T extends HandlerMethodArgumentResolver> T findResolver(HttpServletRequest request, Class<T> resolverClass) {
                    ServletContext servletContext = request.getServletContext();
                    RequestMappingHandlerAdapter mapping = WebMvcClasspathGuard.getRequestMappingHandlerAdapter(servletContext);
                    if (mapping == null) {
                        return null;
                    }
                    List resolvers = mapping.getCustomArgumentResolvers();
                    if (resolvers == null) {
                        return null;
                    }
                    for (HandlerMethodArgumentResolver resolver : resolvers) {
                        if (!resolverClass.isAssignableFrom(resolver.getClass())) continue;
                        return (T)resolver;
                    }
                    return null;
                }

                private static RequestMappingHandlerAdapter getRequestMappingHandlerAdapter(ServletContext servletContext) {
                    String[] names;
                    WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
                    if (context != null && (names = context.getBeanNamesForType(RequestMappingHandlerAdapter.class)).length > 0) {
                        return (RequestMappingHandlerAdapter)context.getBean(names[0]);
                    }
                    return null;
                }
            }
        }

        private static final class TestOAuth2AuthorizedClientManager
        implements OAuth2AuthorizedClientManager {
            static final String TOKEN_ATTR_NAME = TestOAuth2AuthorizedClientManager.class.getName().concat(".TOKEN");
            static final String ENABLED_ATTR_NAME = TestOAuth2AuthorizedClientManager.class.getName().concat(".ENABLED");
            private final OAuth2AuthorizedClientManager delegate;

            private TestOAuth2AuthorizedClientManager(OAuth2AuthorizedClientManager delegate) {
                this.delegate = delegate;
            }

            public OAuth2AuthorizedClient authorize(OAuth2AuthorizeRequest authorizeRequest) {
                HttpServletRequest request = (HttpServletRequest)authorizeRequest.getAttribute(HttpServletRequest.class.getName());
                if (this.isEnabled(request)) {
                    return (OAuth2AuthorizedClient)request.getAttribute(TOKEN_ATTR_NAME);
                }
                return this.delegate.authorize(authorizeRequest);
            }

            static void enable(HttpServletRequest request) {
                request.setAttribute(ENABLED_ATTR_NAME, (Object)Boolean.TRUE);
            }

            boolean isEnabled(HttpServletRequest request) {
                return Boolean.TRUE.equals(request.getAttribute(ENABLED_ATTR_NAME));
            }
        }
    }

    private static abstract class SecurityContextRequestPostProcessorSupport {
        private SecurityContextRequestPostProcessorSupport() {
        }

        final void save(Authentication authentication, HttpServletRequest request) {
            SecurityContext securityContext = SecurityMockMvcRequestPostProcessors.getSecurityContextHolderStrategy(request).createEmptyContext();
            securityContext.setAuthentication(authentication);
            this.save(securityContext, request);
        }

        final void save(SecurityContext securityContext, HttpServletRequest request) {
            SecurityContextRepository securityContextRepository = WebTestUtils.getSecurityContextRepository(request);
            boolean isTestRepository = securityContextRepository instanceof TestSecurityContextRepository;
            if (!isTestRepository) {
                securityContextRepository = new TestSecurityContextRepository(securityContextRepository);
                WebTestUtils.setSecurityContextRepository(request, securityContextRepository);
            }
            MockHttpServletResponse response = new MockHttpServletResponse();
            HttpRequestResponseHolder requestResponseHolder = new HttpRequestResponseHolder(request, (HttpServletResponse)response);
            securityContextRepository.loadContext(requestResponseHolder);
            request = requestResponseHolder.getRequest();
            response = requestResponseHolder.getResponse();
            securityContextRepository.saveContext(securityContext, request, (HttpServletResponse)response);
        }

        static final class TestSecurityContextRepository
        implements SecurityContextRepository {
            private static final String ATTR_NAME = TestSecurityContextRepository.class.getName().concat(".REPO");
            private final SecurityContextRepository delegate;

            private TestSecurityContextRepository(SecurityContextRepository delegate) {
                this.delegate = delegate;
            }

            public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
                SecurityContext result = TestSecurityContextRepository.getContext(requestResponseHolder.getRequest());
                SecurityContext delegateResult = this.delegate.loadContext(requestResponseHolder);
                return result != null ? result : delegateResult;
            }

            public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
                request.setAttribute(ATTR_NAME, (Object)context);
                this.delegate.saveContext(context, request, response);
            }

            public boolean containsContext(HttpServletRequest request) {
                return TestSecurityContextRepository.getContext(request) != null || this.delegate.containsContext(request);
            }

            private static SecurityContext getContext(HttpServletRequest request) {
                return (SecurityContext)request.getAttribute(ATTR_NAME);
            }
        }
    }
}

