/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2ResponseAssertionAccessor;
import org.springframework.util.Assert;

public class Saml2AssertionAuthentication
extends Saml2Authentication {
    private static final long serialVersionUID = -4194323643788693205L;
    private final Saml2ResponseAssertionAccessor assertion;
    private final String relyingPartyRegistrationId;

    public Saml2AssertionAuthentication(Saml2ResponseAssertionAccessor assertion, Collection<? extends GrantedAuthority> authorities, String relyingPartyRegistrationId) {
        super(assertion, assertion.getResponseValue(), authorities);
        this.assertion = assertion;
        this.relyingPartyRegistrationId = relyingPartyRegistrationId;
    }

    public Saml2AssertionAuthentication(Object principal, Saml2ResponseAssertionAccessor assertion, Collection<? extends GrantedAuthority> authorities, String relyingPartyRegistrationId) {
        super(principal, assertion.getResponseValue(), authorities);
        this.assertion = assertion;
        this.relyingPartyRegistrationId = relyingPartyRegistrationId;
        this.setAuthenticated(true);
    }

    protected Saml2AssertionAuthentication(Builder<?> builder) {
        super(builder);
        this.assertion = builder.assertion;
        this.relyingPartyRegistrationId = builder.relyingPartyRegistrationId;
    }

    @Override
    public Saml2ResponseAssertionAccessor getCredentials() {
        return this.assertion;
    }

    public String getRelyingPartyRegistrationId() {
        return this.relyingPartyRegistrationId;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<B extends Builder<B>>
    extends Saml2Authentication.Builder<B> {
        private Saml2ResponseAssertionAccessor assertion;
        private String relyingPartyRegistrationId;

        protected Builder(Saml2AssertionAuthentication token) {
            super(token);
            this.assertion = token.assertion;
            this.relyingPartyRegistrationId = token.relyingPartyRegistrationId;
        }

        public B credentials(@Nullable Object credentials) {
            Assert.isInstanceOf(Saml2ResponseAssertionAccessor.class, (Object)credentials, (String)"credentials must be of type Saml2ResponseAssertionAccessor");
            this.saml2Response(((Saml2ResponseAssertionAccessor)credentials).getResponseValue());
            this.assertion = (Saml2ResponseAssertionAccessor)credentials;
            return (B)((Object)this);
        }

        public B relyingPartyRegistrationId(String relyingPartyRegistrationId) {
            this.relyingPartyRegistrationId = relyingPartyRegistrationId;
            return (B)((Object)this);
        }

        public Saml2AssertionAuthentication build() {
            return new Saml2AssertionAuthentication(this);
        }
    }
}

