/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestUnmarshaller;
import org.opensaml.saml.saml2.core.impl.LogoutResponseBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutResponseMarshaller;
import org.opensaml.saml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.Saml2AssertionAuthentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponse;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationPlaceholderResolvers;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSamlOperations;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2MessageBindingUtils;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2Utils;
import org.springframework.util.Assert;

final class BaseOpenSamlLogoutResponseResolver
implements Saml2LogoutResponseResolver {
    private final Log logger = LogFactory.getLog(this.getClass());
    private XMLObjectProviderRegistry registry;
    private final LogoutRequestUnmarshaller unmarshaller;
    private final LogoutResponseMarshaller marshaller;
    private final LogoutResponseBuilder logoutResponseBuilder;
    private final IssuerBuilder issuerBuilder;
    private final StatusBuilder statusBuilder;
    private final StatusCodeBuilder statusCodeBuilder;
    private final OpenSamlOperations saml;
    private final RelyingPartyRegistrationRepository registrations;
    private final RelyingPartyRegistrationResolver relyingPartyRegistrationResolver;
    private Clock clock = Clock.systemUTC();
    private Consumer<LogoutResponseParameters> parametersConsumer = parameters -> {};

    BaseOpenSamlLogoutResponseResolver(RelyingPartyRegistrationRepository registrations, RelyingPartyRegistrationResolver relyingPartyRegistrationResolver, OpenSamlOperations saml) {
        this.saml = saml;
        this.registrations = registrations;
        this.relyingPartyRegistrationResolver = relyingPartyRegistrationResolver;
        this.registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.unmarshaller = (LogoutRequestUnmarshaller)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(LogoutRequest.DEFAULT_ELEMENT_NAME);
        this.marshaller = (LogoutResponseMarshaller)this.registry.getMarshallerFactory().getMarshaller(LogoutResponse.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.marshaller, (String)"logoutResponseMarshaller must be configured in OpenSAML");
        this.logoutResponseBuilder = (LogoutResponseBuilder)this.registry.getBuilderFactory().getBuilder(LogoutResponse.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.logoutResponseBuilder, (String)"logoutResponseBuilder must be configured in OpenSAML");
        this.issuerBuilder = (IssuerBuilder)this.registry.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.issuerBuilder, (String)"issuerBuilder must be configured in OpenSAML");
        this.statusBuilder = (StatusBuilder)this.registry.getBuilderFactory().getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.statusBuilder, (String)"statusBuilder must be configured in OpenSAML");
        this.statusCodeBuilder = (StatusCodeBuilder)this.registry.getBuilderFactory().getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        Assert.notNull((Object)this.statusCodeBuilder, (String)"statusCodeBuilder must be configured in OpenSAML");
    }

    @Override
    public Saml2LogoutResponse resolve(HttpServletRequest request, Authentication authentication) {
        return this.resolve(request, authentication, "urn:oasis:names:tc:SAML:2.0:status:Success");
    }

    @Override
    public Saml2LogoutResponse resolve(HttpServletRequest request, Authentication authentication, Saml2AuthenticationException authenticationException) {
        return this.resolve(request, authentication, this.getSamlStatus(authenticationException));
    }

    private Saml2LogoutResponse resolve(HttpServletRequest request, Authentication authentication, String statusCode) {
        LogoutRequest logoutRequest = (LogoutRequest)this.saml.deserialize(this.extractSamlRequest(request));
        String registrationId = this.getRegistrationId(authentication);
        RelyingPartyRegistration registration = this.relyingPartyRegistrationResolver.resolve(request, registrationId);
        if (registration == null && this.registrations != null) {
            String issuer = logoutRequest.getIssuer().getValue();
            registration = this.registrations.findUniqueByAssertingPartyEntityId(issuer);
        }
        if (registration == null) {
            return null;
        }
        if (registration.getAssertingPartyMetadata().getSingleLogoutServiceResponseLocation() == null) {
            return null;
        }
        RelyingPartyRegistrationPlaceholderResolvers.UriResolver uriResolver = RelyingPartyRegistrationPlaceholderResolvers.uriResolver(request, registration);
        String entityId = uriResolver.resolve(registration.getEntityId());
        LogoutResponse logoutResponse = this.logoutResponseBuilder.buildObject();
        logoutResponse.setDestination(registration.getAssertingPartyMetadata().getSingleLogoutServiceResponseLocation());
        Issuer issuer = this.issuerBuilder.buildObject();
        issuer.setValue(entityId);
        logoutResponse.setIssuer(issuer);
        StatusCode code = this.statusCodeBuilder.buildObject();
        code.setValue(statusCode);
        Status status = this.statusBuilder.buildObject();
        status.setStatusCode(code);
        logoutResponse.setStatus(status);
        logoutResponse.setInResponseTo(logoutRequest.getID());
        if (logoutResponse.getID() == null) {
            logoutResponse.setID("LR" + String.valueOf(UUID.randomUUID()));
        }
        logoutResponse.setIssueInstant(Instant.now(this.clock));
        this.parametersConsumer.accept(new LogoutResponseParameters(request, registration, authentication, logoutRequest));
        String relayState = request.getParameter("RelayState");
        Saml2LogoutResponse.Builder result = Saml2LogoutResponse.withRelyingPartyRegistration(registration);
        if (registration.getAssertingPartyMetadata().getSingleLogoutServiceBinding() == Saml2MessageBinding.POST) {
            String xml = this.serialize(this.saml.withSigningKeys(registration.getSigningX509Credentials()).algorithms(registration.getAssertingPartyMetadata().getSigningAlgorithms()).sign((LogoutResponse)logoutResponse));
            String samlResponse = Saml2Utils.withDecoded(xml).encode();
            result.samlResponse(samlResponse);
            if (relayState != null) {
                result.relayState(relayState);
            }
            return result.build();
        }
        String xml = this.serialize(logoutResponse);
        String deflatedAndEncoded = Saml2Utils.withDecoded(xml).deflate(true).encode();
        result.samlResponse(deflatedAndEncoded);
        HashMap<String, String> signingParameters = new HashMap<String, String>();
        signingParameters.put("SAMLResponse", deflatedAndEncoded);
        if (relayState != null) {
            signingParameters.put("RelayState", relayState);
        }
        Map<String, String> parameters = this.saml.withSigningKeys(registration.getSigningX509Credentials()).algorithms(registration.getAssertingPartyMetadata().getSigningAlgorithms()).sign(signingParameters);
        return result.parameters(params -> params.putAll(parameters)).build();
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    void setParametersConsumer(Consumer<LogoutResponseParameters> parametersConsumer) {
        this.parametersConsumer = parametersConsumer;
    }

    private String getRegistrationId(Authentication authentication) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Attempting to resolve registrationId from " + String.valueOf(authentication)));
        }
        if (authentication == null) {
            return null;
        }
        if (authentication instanceof Saml2AssertionAuthentication) {
            Saml2AssertionAuthentication saml2 = (Saml2AssertionAuthentication)authentication;
            return saml2.getRelyingPartyRegistrationId();
        }
        Object object = authentication.getPrincipal();
        if (object instanceof Saml2AuthenticatedPrincipal) {
            Saml2AuthenticatedPrincipal saml2 = (Saml2AuthenticatedPrincipal)object;
            return saml2.getRelyingPartyRegistrationId();
        }
        return null;
    }

    private String extractSamlRequest(HttpServletRequest request) {
        return Saml2Utils.withEncoded(request.getParameter("SAMLRequest")).inflate(Saml2MessageBindingUtils.isHttpRedirectBinding(request)).decode();
    }

    private String serialize(LogoutResponse logoutResponse) {
        return this.saml.serialize((XMLObject)logoutResponse).serialize();
    }

    private String getSamlStatus(Saml2AuthenticationException exception) {
        Saml2Error saml2Error = exception.getSaml2Error();
        return switch (saml2Error.getErrorCode()) {
            case "invalid_destination" -> "urn:oasis:names:tc:SAML:2.0:status:RequestDenied";
            case "invalid_request" -> "urn:oasis:names:tc:SAML:2.0:status:Requester";
            default -> "urn:oasis:names:tc:SAML:2.0:status:Responder";
        };
    }

    static {
        OpenSamlInitializationService.initialize();
    }

    static final class LogoutResponseParameters {
        private final HttpServletRequest request;
        private final RelyingPartyRegistration registration;
        private final Authentication authentication;
        private final LogoutRequest logoutRequest;

        LogoutResponseParameters(HttpServletRequest request, RelyingPartyRegistration registration, Authentication authentication, LogoutRequest logoutRequest) {
            this.request = request;
            this.registration = registration;
            this.authentication = authentication;
            this.logoutRequest = logoutRequest;
        }

        HttpServletRequest getRequest() {
            return this.request;
        }

        RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }

        Authentication getAuthentication() {
            return this.authentication;
        }

        LogoutRequest getLogoutRequest() {
            return this.logoutRequest;
        }
    }
}

