/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.AudienceRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.impl.BearerSubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.DelegationRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.impl.ProxyRestrictionConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2ResponseValidatorResult;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.BaseOpenSamlAuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.DefaultSaml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml5Template;
import org.springframework.security.saml2.provider.service.authentication.Saml2AssertionAuthentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.authentication.Saml2ResponseAssertion;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class OpenSaml5AuthenticationProvider
implements AuthenticationProvider {
    private final BaseOpenSamlAuthenticationProvider delegate = new BaseOpenSamlAuthenticationProvider(new OpenSaml5Template());

    public OpenSaml5AuthenticationProvider() {
        this.setResponseValidator(ResponseValidator.withDefaults());
        this.setAssertionValidator(AssertionValidator.withDefaults());
        this.setResponseAuthenticationConverter(new ResponseAuthenticationConverter());
    }

    public void setResponseElementsDecrypter(Consumer<ResponseToken> responseElementsDecrypter) {
        Assert.notNull(responseElementsDecrypter, (String)"responseElementsDecrypter cannot be null");
        this.delegate.setResponseElementsDecrypter((BaseOpenSamlAuthenticationProvider.ResponseToken token) -> responseElementsDecrypter.accept(new ResponseToken((BaseOpenSamlAuthenticationProvider.ResponseToken)token)));
    }

    public void setResponseValidator(Converter<ResponseToken, Saml2ResponseValidatorResult> responseValidator) {
        Assert.notNull(responseValidator, (String)"responseValidator cannot be null");
        this.delegate.setResponseValidator((Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, Saml2ResponseValidatorResult>)((Converter)token -> (Saml2ResponseValidatorResult)responseValidator.convert((Object)new ResponseToken((BaseOpenSamlAuthenticationProvider.ResponseToken)token))));
    }

    public void setAssertionValidator(Converter<AssertionToken, Saml2ResponseValidatorResult> assertionValidator) {
        Assert.notNull(assertionValidator, (String)"assertionValidator cannot be null");
        this.delegate.setAssertionValidator((Converter<BaseOpenSamlAuthenticationProvider.AssertionToken, Saml2ResponseValidatorResult>)((Converter)token -> (Saml2ResponseValidatorResult)assertionValidator.convert((Object)new AssertionToken((BaseOpenSamlAuthenticationProvider.AssertionToken)token))));
    }

    public void setAssertionElementsDecrypter(Consumer<AssertionToken> assertionDecrypter) {
        Assert.notNull(assertionDecrypter, (String)"assertionDecrypter cannot be null");
        this.delegate.setAssertionElementsDecrypter((BaseOpenSamlAuthenticationProvider.AssertionToken token) -> assertionDecrypter.accept(new AssertionToken((BaseOpenSamlAuthenticationProvider.AssertionToken)token)));
    }

    public void setResponseAuthenticationConverter(Converter<ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter) {
        Assert.notNull(responseAuthenticationConverter, (String)"responseAuthenticationConverter cannot be null");
        this.delegate.setResponseAuthenticationConverter((Converter<BaseOpenSamlAuthenticationProvider.ResponseToken, ? extends AbstractAuthenticationToken>)((Converter)token -> (AbstractAuthenticationToken)responseAuthenticationConverter.convert((Object)new ResponseToken((BaseOpenSamlAuthenticationProvider.ResponseToken)token))));
    }

    public void setValidateResponseAfterAssertions(boolean validateResponseAfterAssertions) {
        this.delegate.setValidateResponseAfterAssertions(validateResponseAfterAssertions);
    }

    @Deprecated
    public static Converter<ResponseToken, Saml2ResponseValidatorResult> createDefaultResponseValidator() {
        return ResponseValidator.withDefaults();
    }

    @Deprecated
    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator() {
        return AssertionValidator.withDefaults();
    }

    @Deprecated
    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator(Converter<AssertionToken, ValidationContext> contextConverter) {
        return assertionToken -> {
            Assertion assertion = assertionToken.getAssertion();
            SAML20AssertionValidator validator = BaseOpenSamlAuthenticationProvider.SAML20AssertionValidators.attributeValidator;
            ValidationContext context = (ValidationContext)contextConverter.convert(assertionToken);
            try {
                ValidationResult result = validator.validate(assertion, context);
                if (result == ValidationResult.VALID) {
                    return Saml2ResponseValidatorResult.success();
                }
            }
            catch (Exception ex) {
                String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), ex.getMessage());
                return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_assertion", message));
            }
            String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), context.getValidationFailureMessages());
            return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_assertion", message));
        };
    }

    @Deprecated
    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidatorWithParameters(Consumer<Map<String, Object>> validationContextParameters) {
        return AssertionValidator.builder().validationContextParameters(validationContextParameters).build();
    }

    @Deprecated
    public static Converter<ResponseToken, Saml2Authentication> createDefaultResponseAuthenticationConverter() {
        return new ResponseAuthenticationConverter();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.delegate.authenticate(authentication);
    }

    public boolean supports(Class<?> authentication) {
        return authentication != null && Saml2AuthenticationToken.class.isAssignableFrom(authentication);
    }

    public static final class ResponseValidator
    implements Converter<ResponseToken, Saml2ResponseValidatorResult> {
        private static final List<Converter<ResponseToken, Saml2ResponseValidatorResult>> DEFAULTS = List.of(new InResponseToValidator(), new DestinationValidator(), new IssuerValidator());
        private final List<Converter<ResponseToken, Saml2ResponseValidatorResult>> validators;

        @SafeVarargs
        public ResponseValidator(Converter<ResponseToken, Saml2ResponseValidatorResult> ... validators) {
            this.validators = List.of(validators);
            Assert.notEmpty(this.validators, (String)"validators cannot be empty");
        }

        public static ResponseValidator withDefaults() {
            return new ResponseValidator(new InResponseToValidator(), new DestinationValidator(), new IssuerValidator());
        }

        @SafeVarargs
        public static ResponseValidator withDefaults(Converter<ResponseToken, Saml2ResponseValidatorResult> ... validators) {
            ArrayList<Converter<ResponseToken, Saml2ResponseValidatorResult>> defaults = new ArrayList<Converter<ResponseToken, Saml2ResponseValidatorResult>>(DEFAULTS);
            defaults.addAll(List.of(validators));
            return new ResponseValidator((Converter[])defaults.toArray(Converter[]::new));
        }

        public Saml2ResponseValidatorResult convert(ResponseToken responseToken) {
            Response response = responseToken.getResponse();
            ArrayList<Saml2Error> errors = new ArrayList<Saml2Error>();
            List<String> statusCodes = BaseOpenSamlAuthenticationProvider.getStatusCodes(response);
            if (!BaseOpenSamlAuthenticationProvider.isSuccess(statusCodes)) {
                for (String string : statusCodes) {
                    String message = String.format("Invalid status [%s] for SAML response [%s]", string, response.getID());
                    errors.add(new Saml2Error("invalid_response", message));
                }
            }
            for (Converter converter : this.validators) {
                errors.addAll(((Saml2ResponseValidatorResult)converter.convert((Object)responseToken)).getErrors());
            }
            if (response.getAssertions().isEmpty()) {
                errors.add(new Saml2Error("malformed_response_data", "No assertions found in response."));
            }
            return Saml2ResponseValidatorResult.failure(errors);
        }
    }

    public static final class AssertionValidator
    implements Converter<AssertionToken, Saml2ResponseValidatorResult> {
        private final SAML20AssertionValidator assertionValidator;
        private Consumer<Map<String, Object>> paramsConsumer = map -> {};

        public AssertionValidator(SAML20AssertionValidator assertionValidator) {
            this.assertionValidator = assertionValidator;
        }

        public Saml2ResponseValidatorResult convert(AssertionToken source) {
            Assertion assertion = source.getAssertion();
            ValidationContext validationContext = this.createValidationContext(source);
            try {
                ValidationResult result = this.assertionValidator.validate(assertion, validationContext);
                if (result == ValidationResult.VALID) {
                    return Saml2ResponseValidatorResult.success();
                }
            }
            catch (Exception ex) {
                String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), ex.getMessage());
                return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_assertion", message));
            }
            String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), validationContext.getValidationFailureMessages());
            return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_assertion", message));
        }

        public Saml2ResponseValidatorResult validate(AssertionToken token) {
            return this.convert(token);
        }

        public void setValidationContextParameters(Consumer<Map<String, Object>> paramsConsumer) {
            this.paramsConsumer = paramsConsumer;
        }

        private ValidationContext createValidationContext(AssertionToken assertionToken) {
            Saml2AuthenticationToken token = assertionToken.getToken();
            RelyingPartyRegistration relyingPartyRegistration = token.getRelyingPartyRegistration();
            String audience = relyingPartyRegistration.getEntityId();
            String recipient = relyingPartyRegistration.getAssertionConsumerServiceLocation();
            String assertingPartyEntityId = relyingPartyRegistration.getAssertingPartyMetadata().getEntityId();
            HashMap<String, Object> params = new HashMap<String, Object>();
            Assertion assertion = assertionToken.getAssertion();
            if (AssertionValidator.assertionContainsInResponseTo(assertion)) {
                String requestId = AssertionValidator.getAuthnRequestId(token.getAuthenticationRequest());
                params.put("saml2.SubjectConfirmation.ValidInResponseTo", requestId);
            }
            params.put("saml2.Conditions.ValidAudiences", Collections.singleton(audience));
            params.put("saml2.SubjectConfirmation.ValidRecipients", Collections.singleton(recipient));
            params.put("saml2.ValidIssuers", Collections.singleton(assertingPartyEntityId));
            params.put("saml2.SubjectConfirmation.CheckAddress", false);
            this.paramsConsumer.accept(params);
            return new ValidationContext(params);
        }

        private static boolean assertionContainsInResponseTo(Assertion assertion) {
            if (assertion.getSubject() == null) {
                return false;
            }
            for (SubjectConfirmation confirmation : assertion.getSubject().getSubjectConfirmations()) {
                SubjectConfirmationData confirmationData = confirmation.getSubjectConfirmationData();
                if (confirmationData == null || !StringUtils.hasText((String)confirmationData.getInResponseTo())) continue;
                return true;
            }
            return false;
        }

        private static String getAuthnRequestId(AbstractSaml2AuthenticationRequest serialized) {
            return serialized != null ? serialized.getId() : null;
        }

        public static AssertionValidator withDefaults() {
            return new Builder().build();
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private final List<ConditionValidator> conditions = new ArrayList<ConditionValidator>();
            private final List<SubjectConfirmationValidator> subjects = new ArrayList<SubjectConfirmationValidator>();
            private final Map<String, Object> validationParameters = new HashMap<String, Object>();

            private Builder() {
                this.conditions.add((ConditionValidator)new AudienceRestrictionConditionValidator());
                this.conditions.add((ConditionValidator)new DelegationRestrictionConditionValidator());
                this.conditions.add(new ValidConditionValidator(OneTimeUse.DEFAULT_ELEMENT_NAME));
                this.conditions.add((ConditionValidator)new ProxyRestrictionConditionValidator());
                this.subjects.add((SubjectConfirmationValidator)new BearerSubjectConfirmationValidator());
                this.validationParameters.put("saml2.ClockSkew", Duration.ofMinutes(5L));
            }

            public Builder clockSkew(Duration duration) {
                this.validationParameters.put("saml2.ClockSkew", duration);
                return this;
            }

            public Builder validationContextParameters(Consumer<Map<String, Object>> parameters) {
                parameters.accept(this.validationParameters);
                return this;
            }

            public Builder conditionValidators(Consumer<List<ConditionValidator>> conditions) {
                conditions.accept(this.conditions);
                return this;
            }

            public Builder subjectValidators(Consumer<List<SubjectConfirmationValidator>> subjects) {
                subjects.accept(this.subjects);
                return this;
            }

            public AssertionValidator build() {
                AssertionValidator validator = new AssertionValidator(new ValidSignatureAssertionValidator(this.conditions, this.subjects, List.of(), null, null, null));
                validator.setValidationContextParameters(params -> params.putAll(this.validationParameters));
                return validator;
            }
        }

        private static final class ValidSignatureAssertionValidator
        extends SAML20AssertionValidator {
            private ValidSignatureAssertionValidator(@Nullable Collection<ConditionValidator> newConditionValidators, @Nullable Collection<SubjectConfirmationValidator> newConfirmationValidators, @Nullable Collection<StatementValidator> newStatementValidators, @Nullable org.opensaml.saml.saml2.assertion.AssertionValidator newAssertionValidator, @Nullable SignatureTrustEngine newTrustEngine, @Nullable SignaturePrevalidator newSignaturePrevalidator) {
                super(newConditionValidators, newConfirmationValidators, newStatementValidators, newAssertionValidator, newTrustEngine, newSignaturePrevalidator);
            }

            @Nonnull
            protected ValidationResult validateSignature(@Nonnull Assertion token, @Nonnull ValidationContext context) throws AssertionValidationException {
                return ValidationResult.VALID;
            }
        }

        private static final class ValidConditionValidator
        implements ConditionValidator {
            private final QName name;

            private ValidConditionValidator(QName name) {
                this.name = name;
            }

            @Nonnull
            public QName getServicedCondition() {
                return this.name;
            }

            @Nonnull
            public ValidationResult validate(@Nonnull Condition condition, @Nonnull Assertion assertion, @Nonnull ValidationContext context) {
                return ValidationResult.VALID;
            }
        }
    }

    public static final class ResponseAuthenticationConverter
    implements Converter<ResponseToken, Saml2Authentication> {
        private Converter<Assertion, String> principalNameConverter = ResponseAuthenticationConverter::authenticatedPrincipal;
        private Converter<Assertion, Collection<GrantedAuthority>> grantedAuthoritiesConverter = ResponseAuthenticationConverter::grantedAuthorities;

        public Saml2Authentication convert(ResponseToken responseToken) {
            Response response = responseToken.response;
            Saml2AuthenticationToken token = responseToken.token;
            Assertion assertion = (Assertion)CollectionUtils.firstElement((List)response.getAssertions());
            String username = (String)this.principalNameConverter.convert((Object)assertion);
            String registrationId = responseToken.token.getRelyingPartyRegistration().getRegistrationId();
            Saml2ResponseAssertion accessor = Saml2ResponseAssertion.withResponseValue(token.getSaml2Response()).nameId(ResponseAuthenticationConverter.authenticatedPrincipal(assertion)).sessionIndexes(BaseOpenSamlAuthenticationProvider.getSessionIndexes(assertion)).attributes(BaseOpenSamlAuthenticationProvider.getAssertionAttributes(assertion)).build();
            DefaultSaml2AuthenticatedPrincipal principal = new DefaultSaml2AuthenticatedPrincipal(username, accessor);
            Collection authorities = (Collection)this.grantedAuthoritiesConverter.convert((Object)assertion);
            return new Saml2AssertionAuthentication(principal, accessor, authorities, registrationId);
        }

        public void setPrincipalNameConverter(Converter<Assertion, String> principalNameConverter) {
            Assert.notNull(principalNameConverter, (String)"principalNameConverter cannot be null");
            this.principalNameConverter = principalNameConverter;
        }

        public void setGrantedAuthoritiesConverter(Converter<Assertion, Collection<GrantedAuthority>> grantedAuthoritiesConverter) {
            Assert.notNull(grantedAuthoritiesConverter, (String)"grantedAuthoritiesConverter cannot be null");
            this.grantedAuthoritiesConverter = grantedAuthoritiesConverter;
        }

        private static String authenticatedPrincipal(Assertion assertion) {
            if (!BaseOpenSamlAuthenticationProvider.hasName(assertion)) {
                throw new Saml2AuthenticationException(Saml2Error.subjectNotFound("Assertion [" + assertion.getID() + "] is missing a subject"));
            }
            return assertion.getSubject().getNameID().getValue();
        }

        private static Collection<GrantedAuthority> grantedAuthorities(Assertion assertion) {
            return AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"});
        }
    }

    public static class AssertionToken {
        private final Saml2AuthenticationToken token;
        private final Assertion assertion;

        AssertionToken(Assertion assertion, Saml2AuthenticationToken token) {
            this.token = token;
            this.assertion = assertion;
        }

        AssertionToken(BaseOpenSamlAuthenticationProvider.AssertionToken token) {
            this.token = token.getToken();
            this.assertion = token.getAssertion();
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    public static class ResponseToken {
        private final Saml2AuthenticationToken token;
        private final Response response;

        ResponseToken(Response response, Saml2AuthenticationToken token) {
            this.token = token;
            this.response = response;
        }

        ResponseToken(BaseOpenSamlAuthenticationProvider.ResponseToken token) {
            this.token = token.getToken();
            this.response = token.getResponse();
        }

        public Response getResponse() {
            return this.response;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    public static final class IssuerValidator
    implements Converter<ResponseToken, Saml2ResponseValidatorResult> {
        @NonNull
        public Saml2ResponseValidatorResult convert(ResponseToken responseToken) {
            Response response = responseToken.getResponse();
            Saml2AuthenticationToken token = responseToken.getToken();
            String issuer = response.getIssuer().getValue();
            String assertingPartyEntityId = token.getRelyingPartyRegistration().getAssertingPartyMetadata().getEntityId();
            if (!StringUtils.hasText((String)issuer) || !issuer.equals(assertingPartyEntityId)) {
                String message = String.format("Invalid issuer [%s] for SAML response [%s]", issuer, response.getID());
                return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_issuer", message));
            }
            return Saml2ResponseValidatorResult.success();
        }
    }

    public static final class DestinationValidator
    implements Converter<ResponseToken, Saml2ResponseValidatorResult> {
        @NonNull
        public Saml2ResponseValidatorResult convert(ResponseToken responseToken) {
            Response response = responseToken.getResponse();
            Saml2AuthenticationToken token = responseToken.getToken();
            String destination = response.getDestination();
            String location = token.getRelyingPartyRegistration().getAssertionConsumerServiceLocation();
            if (StringUtils.hasText((String)destination) && !destination.equals(location)) {
                String message = "Invalid destination [" + destination + "] for SAML response [" + response.getID() + "]";
                return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_destination", message));
            }
            return Saml2ResponseValidatorResult.success();
        }
    }

    public static final class InResponseToValidator
    implements Converter<ResponseToken, Saml2ResponseValidatorResult> {
        @NonNull
        public Saml2ResponseValidatorResult convert(ResponseToken responseToken) {
            AbstractSaml2AuthenticationRequest request = responseToken.getToken().getAuthenticationRequest();
            Response response = responseToken.getResponse();
            String inResponseTo = response.getInResponseTo();
            return BaseOpenSamlAuthenticationProvider.validateInResponseTo(request, inResponseTo);
        }
    }
}

