/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication.logout;

import java.util.Collection;
import java.util.function.Consumer;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.core.impl.LogoutResponseUnmarshaller;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSaml4Template;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSamlOperations;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponse;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponseValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponseValidatorParameters;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutValidatorResult;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2Utils;
import org.springframework.security.saml2.provider.service.registration.AssertingPartyMetadata;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

@Deprecated
public class OpenSamlLogoutResponseValidator
implements Saml2LogoutResponseValidator {
    private final XMLObjectProviderRegistry registry;
    private final LogoutResponseUnmarshaller unmarshaller;
    private final OpenSamlOperations saml = new OpenSaml4Template();

    public OpenSamlLogoutResponseValidator() {
        this.registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.unmarshaller = (LogoutResponseUnmarshaller)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(LogoutResponse.DEFAULT_ELEMENT_NAME);
    }

    @Override
    public Saml2LogoutValidatorResult validate(Saml2LogoutResponseValidatorParameters parameters) {
        Saml2LogoutResponse response = parameters.getLogoutResponse();
        Saml2LogoutRequest request = parameters.getLogoutRequest();
        RelyingPartyRegistration registration = parameters.getRelyingPartyRegistration();
        LogoutResponse logoutResponse = (LogoutResponse)this.saml.deserialize(Saml2Utils.withEncoded(response.getSamlResponse()).inflate(response.getBinding() == Saml2MessageBinding.REDIRECT).decode());
        return Saml2LogoutValidatorResult.withErrors(new Saml2Error[0]).errors(this.verifySignature(response, logoutResponse, registration)).errors(this.validateRequest(logoutResponse, registration)).errors(this.validateLogoutRequest(logoutResponse, request.getId())).build();
    }

    private Consumer<Collection<Saml2Error>> verifySignature(Saml2LogoutResponse response, LogoutResponse logoutResponse, RelyingPartyRegistration registration) {
        return errors -> {
            AssertingPartyMetadata details = registration.getAssertingPartyMetadata();
            Collection<Saml2X509Credential> credentials = details.getVerificationX509Credentials();
            OpenSamlOperations.VerificationConfigurer verify = this.saml.withVerificationKeys(credentials).entityId(details.getEntityId());
            if (logoutResponse.isSigned()) {
                errors.addAll(verify.verify((SignableXMLObject)logoutResponse));
            } else {
                OpenSamlOperations.VerificationConfigurer.RedirectParameters params = new OpenSamlOperations.VerificationConfigurer.RedirectParameters(response.getParameters(), response.getParametersQuery(), (StatusResponseType)logoutResponse);
                errors.addAll(verify.verify(params));
            }
        };
    }

    private Consumer<Collection<Saml2Error>> validateRequest(LogoutResponse response, RelyingPartyRegistration registration) {
        return errors -> {
            this.validateIssuer(response, registration).accept((Collection<Saml2Error>)errors);
            this.validateDestination(response, registration).accept((Collection<Saml2Error>)errors);
            this.validateStatus(response).accept((Collection<Saml2Error>)errors);
        };
    }

    private Consumer<Collection<Saml2Error>> validateIssuer(LogoutResponse response, RelyingPartyRegistration registration) {
        return errors -> {
            if (response.getIssuer() == null) {
                errors.add(new Saml2Error("invalid_issuer", "Failed to find issuer in LogoutResponse"));
                return;
            }
            String issuer = response.getIssuer().getValue();
            if (!issuer.equals(registration.getAssertingPartyMetadata().getEntityId())) {
                errors.add(new Saml2Error("invalid_issuer", "Failed to match issuer to configured issuer"));
            }
        };
    }

    private Consumer<Collection<Saml2Error>> validateDestination(LogoutResponse response, RelyingPartyRegistration registration) {
        return errors -> {
            if (response.getDestination() == null) {
                errors.add(new Saml2Error("invalid_destination", "Failed to find destination in LogoutResponse"));
                return;
            }
            String destination = response.getDestination();
            if (!destination.equals(registration.getSingleLogoutServiceResponseLocation())) {
                errors.add(new Saml2Error("invalid_destination", "Failed to match destination to configured destination"));
            }
        };
    }

    private Consumer<Collection<Saml2Error>> validateStatus(LogoutResponse response) {
        return errors -> {
            if (response.getStatus() == null) {
                return;
            }
            if (response.getStatus().getStatusCode() == null) {
                return;
            }
            if ("urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
                return;
            }
            if ("urn:oasis:names:tc:SAML:2.0:status:PartialLogout".equals(response.getStatus().getStatusCode().getValue())) {
                return;
            }
            errors.add(new Saml2Error("invalid_response", "Response indicated logout failed"));
        };
    }

    private Consumer<Collection<Saml2Error>> validateLogoutRequest(LogoutResponse response, String id) {
        return errors -> {
            if (response.getInResponseTo() == null) {
                return;
            }
            if (response.getInResponseTo().equals(id)) {
                return;
            }
            errors.add(new Saml2Error("invalid_response", "LogoutResponse InResponseTo doesn't match ID of associated LogoutRequest"));
        };
    }

    static {
        OpenSamlInitializationService.initialize();
    }
}

