/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationPlaceholderResolvers;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class DefaultRelyingPartyRegistrationResolver
implements Converter<HttpServletRequest, RelyingPartyRegistration>,
RelyingPartyRegistrationResolver {
    private Log logger = LogFactory.getLog(this.getClass());
    private final RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private final RequestMatcher registrationRequestMatcher = new AntPathRequestMatcher("/**/{registrationId}");

    public DefaultRelyingPartyRegistrationResolver(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        Assert.notNull((Object)relyingPartyRegistrationRepository, (String)"relyingPartyRegistrationRepository cannot be null");
        this.relyingPartyRegistrationRepository = relyingPartyRegistrationRepository;
    }

    public RelyingPartyRegistration convert(HttpServletRequest request) {
        return this.resolve(request, null);
    }

    @Override
    public RelyingPartyRegistration resolve(HttpServletRequest request, String relyingPartyRegistrationId) {
        if (relyingPartyRegistrationId == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Attempting to resolve from " + String.valueOf(this.registrationRequestMatcher) + " since registrationId is null"));
            }
            relyingPartyRegistrationId = (String)this.registrationRequestMatcher.matcher(request).getVariables().get("registrationId");
        }
        if (relyingPartyRegistrationId == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Returning null registration since registrationId is null");
            }
            return null;
        }
        RelyingPartyRegistration registration = this.relyingPartyRegistrationRepository.findByRegistrationId(relyingPartyRegistrationId);
        if (registration == null) {
            return null;
        }
        RelyingPartyRegistrationPlaceholderResolvers.UriResolver uriResolver = RelyingPartyRegistrationPlaceholderResolvers.uriResolver(request, registration);
        return registration.mutate().entityId(uriResolver.resolve(registration.getEntityId())).assertionConsumerServiceLocation(uriResolver.resolve(registration.getAssertionConsumerServiceLocation())).singleLogoutServiceLocation(uriResolver.resolve(registration.getSingleLogoutServiceLocation())).singleLogoutServiceResponseLocation(uriResolver.resolve(registration.getSingleLogoutServiceResponseLocation())).build();
    }
}

