/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication.logout;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.time.Instant;
import java.util.function.Consumer;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponse;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSamlLogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseResolver;
import org.springframework.util.Assert;

public final class OpenSaml4LogoutResponseResolver
implements Saml2LogoutResponseResolver {
    private final OpenSamlLogoutResponseResolver logoutResponseResolver;
    private Consumer<LogoutResponseParameters> parametersConsumer = parameters -> {};
    private Clock clock = Clock.systemUTC();

    public OpenSaml4LogoutResponseResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        this.logoutResponseResolver = new OpenSamlLogoutResponseResolver(relyingPartyRegistrationResolver);
    }

    @Override
    public Saml2LogoutResponse resolve(HttpServletRequest request, Authentication authentication) {
        return this.logoutResponseResolver.resolve(request, authentication, (registration, logoutResponse) -> {
            logoutResponse.setIssueInstant(Instant.now(this.clock));
            this.parametersConsumer.accept(new LogoutResponseParameters(request, (RelyingPartyRegistration)registration, authentication, (LogoutResponse)logoutResponse));
        });
    }

    public void setParametersConsumer(Consumer<LogoutResponseParameters> parametersConsumer) {
        Assert.notNull(parametersConsumer, (String)"parametersConsumer cannot be null");
        this.parametersConsumer = parametersConsumer;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock must not be null");
        this.clock = clock;
    }

    public static final class LogoutResponseParameters {
        private final HttpServletRequest request;
        private final RelyingPartyRegistration registration;
        private final Authentication authentication;
        private final LogoutResponse logoutResponse;

        public LogoutResponseParameters(HttpServletRequest request, RelyingPartyRegistration registration, Authentication authentication, LogoutResponse logoutResponse) {
            this.request = request;
            this.registration = registration;
            this.authentication = authentication;
            this.logoutResponse = logoutResponse;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public LogoutResponse getLogoutResponse() {
            return this.logoutResponse;
        }
    }
}

