/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Clock;
import java.util.function.Consumer;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.OpenSamlAuthenticationRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.util.Assert;

@Deprecated
public final class OpenSaml3AuthenticationRequestResolver
implements Saml2AuthenticationRequestResolver {
    private final OpenSamlAuthenticationRequestResolver authnRequestResolver;
    private Consumer<AuthnRequestContext> contextConsumer = parameters -> {};
    private Clock clock = Clock.systemUTC();

    public OpenSaml3AuthenticationRequestResolver(RelyingPartyRegistrationResolver relyingPartyRegistrationResolver) {
        this.authnRequestResolver = new OpenSamlAuthenticationRequestResolver(relyingPartyRegistrationResolver);
    }

    @Override
    public <T extends AbstractSaml2AuthenticationRequest> T resolve(HttpServletRequest request) {
        return this.authnRequestResolver.resolve(request, (registration, authnRequest) -> {
            authnRequest.setIssueInstant(new DateTime(this.clock.millis()));
            this.contextConsumer.accept(new AuthnRequestContext(request, (RelyingPartyRegistration)registration, (AuthnRequest)authnRequest));
        });
    }

    public void setAuthnRequestCustomizer(Consumer<AuthnRequestContext> contextConsumer) {
        Assert.notNull(contextConsumer, (String)"contextConsumer cannot be null");
        this.contextConsumer = contextConsumer;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock must not be null");
        this.clock = clock;
    }

    public static final class AuthnRequestContext {
        private final HttpServletRequest request;
        private final RelyingPartyRegistration registration;
        private final AuthnRequest authnRequest;

        public AuthnRequestContext(HttpServletRequest request, RelyingPartyRegistration registration, AuthnRequest authnRequest) {
            this.request = request;
            this.registration = registration;
            this.authnRequest = authnRequest;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public RelyingPartyRegistration getRelyingPartyRegistration() {
            return this.registration;
        }

        public AuthnRequest getAuthnRequest() {
            return this.authnRequest;
        }
    }
}

