/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.servlet.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2PostAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2RedirectAuthenticationRequest;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.Saml2AuthenticationRequestResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class Saml2WebSsoAuthenticationRequestFilter
extends OncePerRequestFilter {
    private final Saml2AuthenticationRequestResolver authenticationRequestResolver;
    private Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository = new HttpSessionSaml2AuthenticationRequestRepository();

    public Saml2WebSsoAuthenticationRequestFilter(Saml2AuthenticationRequestResolver authenticationRequestResolver) {
        Assert.notNull((Object)authenticationRequestResolver, (String)"authenticationRequestResolver cannot be null");
        this.authenticationRequestResolver = authenticationRequestResolver;
    }

    public void setAuthenticationRequestRepository(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        Assert.notNull(authenticationRequestRepository, (String)"authenticationRequestRepository cannot be null");
        this.authenticationRequestRepository = authenticationRequestRepository;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object authenticationRequest = this.authenticationRequestResolver.resolve(request);
        if (authenticationRequest == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (authenticationRequest instanceof Saml2RedirectAuthenticationRequest) {
            this.sendRedirect(request, response, (Saml2RedirectAuthenticationRequest)authenticationRequest);
        } else {
            this.sendPost(request, response, (Saml2PostAuthenticationRequest)authenticationRequest);
        }
    }

    private void sendRedirect(HttpServletRequest request, HttpServletResponse response, Saml2RedirectAuthenticationRequest authenticationRequest) throws IOException {
        this.authenticationRequestRepository.saveAuthenticationRequest(authenticationRequest, request, response);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authenticationRequest.getAuthenticationRequestUri());
        this.addParameter("SAMLRequest", authenticationRequest.getSamlRequest(), uriBuilder);
        this.addParameter("RelayState", authenticationRequest.getRelayState(), uriBuilder);
        this.addParameter("SigAlg", authenticationRequest.getSigAlg(), uriBuilder);
        this.addParameter("Signature", authenticationRequest.getSignature(), uriBuilder);
        String redirectUrl = uriBuilder.build(true).toUriString();
        response.sendRedirect(redirectUrl);
    }

    private void addParameter(String name, String value, UriComponentsBuilder builder) {
        Assert.hasText((String)name, (String)"name cannot be empty or null");
        if (StringUtils.hasText((String)value)) {
            builder.queryParam(UriUtils.encode((String)name, (Charset)StandardCharsets.ISO_8859_1), new Object[]{UriUtils.encode((String)value, (Charset)StandardCharsets.ISO_8859_1)});
        }
    }

    private void sendPost(HttpServletRequest request, HttpServletResponse response, Saml2PostAuthenticationRequest authenticationRequest) throws IOException {
        this.authenticationRequestRepository.saveAuthenticationRequest(authenticationRequest, request, response);
        String html = this.createSamlPostRequestFormData(authenticationRequest);
        response.setContentType("text/html");
        response.getWriter().write(html);
    }

    private String createSamlPostRequestFormData(Saml2PostAuthenticationRequest authenticationRequest) {
        String authenticationRequestUri = authenticationRequest.getAuthenticationRequestUri();
        String relayState = authenticationRequest.getRelayState();
        String samlRequest = authenticationRequest.getSamlRequest();
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n");
        html.append("<html>\n").append("    <head>\n");
        html.append("        <meta charset=\"utf-8\" />\n");
        html.append("    </head>\n");
        html.append("    <body onload=\"document.forms[0].submit()\">\n");
        html.append("        <noscript>\n");
        html.append("            <p>\n");
        html.append("                <strong>Note:</strong> Since your browser does not support JavaScript,\n");
        html.append("                you must press the Continue button once to proceed.\n");
        html.append("            </p>\n");
        html.append("        </noscript>\n");
        html.append("        \n");
        html.append("        <form action=\"");
        html.append(authenticationRequestUri);
        html.append("\" method=\"post\">\n");
        html.append("            <div>\n");
        html.append("                <input type=\"hidden\" name=\"SAMLRequest\" value=\"");
        html.append(HtmlUtils.htmlEscape((String)samlRequest));
        html.append("\"/>\n");
        if (StringUtils.hasText((String)relayState)) {
            html.append("                <input type=\"hidden\" name=\"RelayState\" value=\"");
            html.append(HtmlUtils.htmlEscape((String)relayState));
            html.append("\"/>\n");
        }
        html.append("            </div>\n");
        html.append("            <noscript>\n");
        html.append("                <div>\n");
        html.append("                    <input type=\"submit\" value=\"Continue\"/>\n");
        html.append("                </div>\n");
        html.append("            </noscript>\n");
        html.append("        </form>\n");
        html.append("        \n");
        html.append("    </body>\n");
        html.append("</html>");
        return html.toString();
    }
}

