/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.servlet.filter;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.HttpSessionSaml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestRepository;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationTokenConverter;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.Assert;

public class Saml2WebSsoAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    public static final String DEFAULT_FILTER_PROCESSES_URI = "/login/saml2/sso/{registrationId}";
    private final AuthenticationConverter authenticationConverter;
    private Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository = new HttpSessionSaml2AuthenticationRequestRepository();

    public Saml2WebSsoAuthenticationFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        this(relyingPartyRegistrationRepository, DEFAULT_FILTER_PROCESSES_URI);
    }

    public Saml2WebSsoAuthenticationFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository, String filterProcessesUrl) {
        this(new Saml2AuthenticationTokenConverter(new DefaultRelyingPartyRegistrationResolver(relyingPartyRegistrationRepository)), filterProcessesUrl);
        Assert.isTrue((boolean)filterProcessesUrl.contains("{registrationId}"), (String)"filterProcessesUrl must contain a {registrationId} match variable");
    }

    public Saml2WebSsoAuthenticationFilter(AuthenticationConverter authenticationConverter, String filterProcessesUrl) {
        super(filterProcessesUrl);
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        Assert.hasText((String)filterProcessesUrl, (String)"filterProcessesUrl must contain a URL pattern");
        this.authenticationConverter = authenticationConverter;
        this.setAllowSessionCreation(true);
        this.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new ChangeSessionIdAuthenticationStrategy());
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return super.requiresAuthentication(request, response);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Authentication authentication = this.authenticationConverter.convert(request);
        if (authentication == null) {
            Saml2Error saml2Error = new Saml2Error("relying_party_registration_not_found", "No relying party registration found");
            throw new Saml2AuthenticationException(saml2Error);
        }
        this.setDetails(request, authentication);
        this.authenticationRequestRepository.removeAuthenticationRequest(request, response);
        return this.getAuthenticationManager().authenticate(authentication);
    }

    public void setAuthenticationRequestRepository(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        Assert.notNull(authenticationRequestRepository, (String)"authenticationRequestRepository cannot be null");
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.setAuthenticationRequestRepositoryIntoAuthenticationConverter(authenticationRequestRepository);
    }

    private void setAuthenticationRequestRepositoryIntoAuthenticationConverter(Saml2AuthenticationRequestRepository<AbstractSaml2AuthenticationRequest> authenticationRequestRepository) {
        if (this.authenticationConverter instanceof Saml2AuthenticationTokenConverter) {
            Saml2AuthenticationTokenConverter authenticationTokenConverter = (Saml2AuthenticationTokenConverter)this.authenticationConverter;
            authenticationTokenConverter.setAuthenticationRequestRepository(authenticationRequestRepository);
        }
    }

    private void setDetails(HttpServletRequest request, Authentication authentication) {
        if (AbstractAuthenticationToken.class.isAssignableFrom(authentication.getClass())) {
            Object details = this.authenticationDetailsSource.buildDetails((Object)request);
            ((AbstractAuthenticationToken)authentication).setDetails(details);
        }
    }
}

