/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;

public class Saml2PostAuthenticationRequest
extends AbstractSaml2AuthenticationRequest {
    Saml2PostAuthenticationRequest(String samlRequest, String relayState, String authenticationRequestUri, String relyingPartyRegistrationId) {
        super(samlRequest, relayState, authenticationRequestUri, relyingPartyRegistrationId);
    }

    @Override
    public Saml2MessageBinding getBinding() {
        return Saml2MessageBinding.POST;
    }

    public static Builder withRelyingPartyRegistration(RelyingPartyRegistration registration) {
        String location = registration.getAssertingPartyDetails().getSingleSignOnServiceLocation();
        return (Builder)new Builder(registration).authenticationRequestUri(location);
    }

    public static final class Builder
    extends AbstractSaml2AuthenticationRequest.Builder<Builder> {
        private Builder(RelyingPartyRegistration registration) {
            super(registration);
        }

        public Saml2PostAuthenticationRequest build() {
            return new Saml2PostAuthenticationRequest(this.samlRequest, this.relayState, this.authenticationRequestUri, this.relyingPartyRegistrationId);
        }
    }
}

