/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.rsocket.core;

import io.rsocket.ConnectionSetupPayload;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import io.rsocket.metadata.WellKnownMimeType;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.security.rsocket.api.PayloadExchangeType;
import org.springframework.security.rsocket.api.PayloadInterceptor;
import org.springframework.security.rsocket.core.ContextPayloadInterceptorChain;
import org.springframework.security.rsocket.core.DefaultPayloadExchange;
import org.springframework.security.rsocket.core.PayloadInterceptorRSocket;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

class PayloadSocketAcceptor
implements SocketAcceptor {
    private final SocketAcceptor delegate;
    private final List<PayloadInterceptor> interceptors;
    @Nullable
    private MimeType defaultDataMimeType;
    private MimeType defaultMetadataMimeType = MimeTypeUtils.parseMimeType((String)WellKnownMimeType.MESSAGE_RSOCKET_COMPOSITE_METADATA.getString());

    PayloadSocketAcceptor(SocketAcceptor delegate, List<PayloadInterceptor> interceptors) {
        Assert.notNull((Object)delegate, (String)"delegate cannot be null");
        if (interceptors == null) {
            throw new IllegalArgumentException("interceptors cannot be null");
        }
        if (interceptors.isEmpty()) {
            throw new IllegalArgumentException("interceptors cannot be empty");
        }
        this.delegate = delegate;
        this.interceptors = interceptors;
    }

    public Mono<RSocket> accept(ConnectionSetupPayload setup, RSocket sendingSocket) {
        MimeType dataMimeType = this.parseMimeType(setup.dataMimeType(), this.defaultDataMimeType);
        Assert.notNull((Object)dataMimeType, (String)"No `dataMimeType` in ConnectionSetupPayload and no default value");
        MimeType metadataMimeType = this.parseMimeType(setup.metadataMimeType(), this.defaultMetadataMimeType);
        Assert.notNull((Object)metadataMimeType, (String)"No `metadataMimeType` in ConnectionSetupPayload and no default value");
        return this.intercept((Payload)setup, dataMimeType, metadataMimeType).flatMap(ctx -> this.delegate.accept(setup, sendingSocket).map(acceptingSocket -> new PayloadInterceptorRSocket((RSocket)acceptingSocket, this.interceptors, metadataMimeType, dataMimeType, (Context)ctx)));
    }

    private Mono<Context> intercept(Payload payload, MimeType dataMimeType, MimeType metadataMimeType) {
        return Mono.defer(() -> {
            ContextPayloadInterceptorChain chain = new ContextPayloadInterceptorChain(this.interceptors);
            DefaultPayloadExchange exchange = new DefaultPayloadExchange(PayloadExchangeType.SETUP, payload, metadataMimeType, dataMimeType);
            return chain.next(exchange).then(Mono.fromCallable(() -> chain.getContext())).defaultIfEmpty((Object)Context.empty());
        });
    }

    private MimeType parseMimeType(String str, MimeType defaultMimeType) {
        return StringUtils.hasText((String)str) ? MimeTypeUtils.parseMimeType((String)str) : defaultMimeType;
    }

    public void setDefaultDataMimeType(@Nullable MimeType defaultDataMimeType) {
        this.defaultDataMimeType = defaultDataMimeType;
    }

    public void setDefaultMetadataMimeType(MimeType defaultMetadataMimeType) {
        Assert.notNull((Object)defaultMetadataMimeType, (String)"defaultMetadataMimeType cannot be null");
        this.defaultMetadataMimeType = defaultMetadataMimeType;
    }
}

