/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.util.Collection;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.Transient;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.Assert;

@Transient
public class JwtAuthenticationToken
extends AbstractOAuth2TokenAuthenticationToken<Jwt> {
    private static final long serialVersionUID = 620L;
    private final String name;

    public JwtAuthenticationToken(Jwt jwt) {
        super(jwt);
        this.name = jwt.getSubject();
    }

    public JwtAuthenticationToken(Jwt jwt, Collection<? extends GrantedAuthority> authorities) {
        super(jwt, authorities);
        this.setAuthenticated(true);
        this.name = jwt.getSubject();
    }

    public JwtAuthenticationToken(Jwt jwt, Collection<? extends GrantedAuthority> authorities, String name) {
        super(jwt, authorities);
        this.setAuthenticated(true);
        this.name = name;
    }

    protected JwtAuthenticationToken(Builder<?> builder) {
        super(builder);
        this.name = builder.name;
    }

    @Override
    public Map<String, Object> getTokenAttributes() {
        return ((Jwt)this.getToken()).getClaims();
    }

    public String getName() {
        return this.name;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOAuth2TokenAuthenticationToken.AbstractOAuth2TokenAuthenticationBuilder<Jwt, B> {
        private String name;

        protected Builder(JwtAuthenticationToken token) {
            super(token);
            this.name = token.getName();
        }

        @Override
        public B principal(@Nullable Object principal) {
            Assert.isInstanceOf(Jwt.class, (Object)principal, (String)"principal must be of type Jwt");
            return this.token((Jwt)principal);
        }

        @Override
        public B credentials(@Nullable Object credentials) {
            Assert.isInstanceOf(Jwt.class, (Object)credentials, (String)"credentials must be of type Jwt");
            return this.token((Jwt)credentials);
        }

        @Override
        public B token(Jwt token) {
            super.principal(token);
            super.credentials(token);
            return ((Builder)((Object)super.token(token))).name(token.getSubject());
        }

        public B name(String name) {
            this.name = name;
            return (B)((Object)this);
        }

        public JwtAuthenticationToken build() {
            return new JwtAuthenticationToken(this);
        }
    }
}

