/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.KeySourceException;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;

class JWKSelectorFactory {
    private final DelegateSelectorFactory delegate;

    JWKSelectorFactory(JWSAlgorithm expectedJWSAlgorithm) {
        this.delegate = new DelegateSelectorFactory(expectedJWSAlgorithm);
    }

    JWKSelector createSelector(JWSHeader jwsHeader) {
        return new JWKSelector(this.delegate.createJWKMatcher(jwsHeader));
    }

    private static class DelegateSelectorFactory
    extends JWSVerificationKeySelector {
        public DelegateSelectorFactory(JWSAlgorithm jwsAlg) {
            super(jwsAlg, (jwkSelector, context) -> {
                throw new KeySourceException("JWKSelectorFactory is only intended for creating a selector");
            });
        }

        public JWKMatcher createJWKMatcher(JWSHeader jwsHeader) {
            return super.createJWKMatcher(jwsHeader);
        }
    }
}

