/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public final class MappedJwtClaimSetConverter
implements Converter<Map<String, Object>, Map<String, Object>> {
    private static final Converter<Object, Collection<String>> AUDIENCE_CONVERTER = new AudienceConverter();
    private static final Converter<Object, String> ISSUER_CONVERTER = new IssuerConverter();
    private static final Converter<Object, String> STRING_CONVERTER = new StringConverter();
    private static final Converter<Object, Instant> TEMPORAL_CONVERTER = new InstantConverter();
    private final Map<String, Converter<Object, ?>> claimConverters;

    public MappedJwtClaimSetConverter(Map<String, Converter<Object, ?>> claimConverters) {
        Assert.notNull(claimConverters, (String)"claimConverters cannot be null");
        this.claimConverters = new HashMap(claimConverters);
    }

    public static MappedJwtClaimSetConverter withDefaults(Map<String, Converter<Object, ?>> claimConverters) {
        Assert.notNull(claimConverters, (String)"claimConverters cannot be null");
        HashMap claimNameToConverter = new HashMap();
        claimNameToConverter.put("aud", AUDIENCE_CONVERTER);
        claimNameToConverter.put("exp", TEMPORAL_CONVERTER);
        claimNameToConverter.put("iat", TEMPORAL_CONVERTER);
        claimNameToConverter.put("iss", ISSUER_CONVERTER);
        claimNameToConverter.put("jti", STRING_CONVERTER);
        claimNameToConverter.put("nbf", TEMPORAL_CONVERTER);
        claimNameToConverter.put("sub", STRING_CONVERTER);
        claimNameToConverter.putAll(claimConverters);
        return new MappedJwtClaimSetConverter(claimNameToConverter);
    }

    public Map<String, Object> convert(Map<String, Object> claims) {
        Assert.notNull(claims, (String)"claims cannot be null");
        HashMap<String, Object> mappedClaims = new HashMap<String, Object>(claims);
        for (Map.Entry<String, Converter<Object, ?>> entry : this.claimConverters.entrySet()) {
            String claimName = entry.getKey();
            Converter<Object, ?> converter = entry.getValue();
            if (converter == null) continue;
            Object claim = claims.get(claimName);
            Object mappedClaim = converter.convert(claim);
            mappedClaims.compute(claimName, (key, value) -> mappedClaim);
        }
        Instant issuedAt = (Instant)mappedClaims.get("iat");
        Instant expiresAt = (Instant)mappedClaims.get("exp");
        if (issuedAt == null && expiresAt != null) {
            mappedClaims.put("iat", expiresAt.minusSeconds(1L));
        }
        return mappedClaims;
    }

    private static class StringConverter
    implements Converter<Object, String> {
        private StringConverter() {
        }

        public String convert(Object source) {
            if (source == null) {
                return null;
            }
            return source.toString();
        }
    }

    private static class InstantConverter
    implements Converter<Object, Instant> {
        private InstantConverter() {
        }

        public Instant convert(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof Instant) {
                return (Instant)source;
            }
            if (source instanceof Date) {
                return ((Date)source).toInstant();
            }
            if (source instanceof Number) {
                return Instant.ofEpochSecond(((Number)source).longValue());
            }
            try {
                return Instant.ofEpochSecond(Long.parseLong(source.toString()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not coerce " + source + " into an Instant", e);
            }
        }
    }

    private static class IssuerConverter
    implements Converter<Object, String> {
        private IssuerConverter() {
        }

        public String convert(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof URL) {
                return ((URL)source).toExternalForm();
            }
            if (source instanceof String && ((String)source).contains(":")) {
                try {
                    return URI.create((String)source).toString();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not coerce " + source + " into a URI String", e);
                }
            }
            return source.toString();
        }
    }

    private static class AudienceConverter
    implements Converter<Object, Collection<String>> {
        private AudienceConverter() {
        }

        public Collection<String> convert(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof Collection) {
                return ((Collection)source).stream().filter(Objects::nonNull).map(Objects::toString).collect(Collectors.toList());
            }
            return Arrays.asList(source.toString());
        }
    }
}

