/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.util.Assert;

public final class NimbusJwtDecoderJwkSupport
implements JwtDecoder {
    private final URL jwkSetUrl;
    private final JWSAlgorithm jwsAlgorithm;
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor;

    public NimbusJwtDecoderJwkSupport(String jwkSetUrl) {
        this(jwkSetUrl, "RS256");
    }

    public NimbusJwtDecoderJwkSupport(String jwkSetUrl, String jwsAlgorithm) {
        Assert.hasText((String)jwkSetUrl, (String)"jwkSetUrl cannot be empty");
        Assert.hasText((String)jwsAlgorithm, (String)"jwsAlgorithm cannot be empty");
        try {
            this.jwkSetUrl = new URL(jwkSetUrl);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid JWK Set URL " + jwkSetUrl + " : " + ex.getMessage(), ex);
        }
        this.jwsAlgorithm = JWSAlgorithm.parse((String)jwsAlgorithm);
        DefaultResourceRetriever jwkSetRetriever = new DefaultResourceRetriever(30000, 30000);
        RemoteJWKSet jwkSource = new RemoteJWKSet(this.jwkSetUrl, (ResourceRetriever)jwkSetRetriever);
        JWSVerificationKeySelector jwsKeySelector = new JWSVerificationKeySelector(this.jwsAlgorithm, (JWKSource)jwkSource);
        this.jwtProcessor = new DefaultJWTProcessor();
        this.jwtProcessor.setJWSKeySelector((JWSKeySelector)jwsKeySelector);
    }

    @Override
    public Jwt decode(String token) throws JwtException {
        JWT jwt = this.parse(token);
        if (jwt instanceof SignedJWT) {
            return this.createJwt(token, jwt);
        }
        throw new JwtException("Unsupported algorithm of " + jwt.getHeader().getAlgorithm());
    }

    private JWT parse(String token) {
        try {
            return JWTParser.parse((String)token);
        }
        catch (Exception ex) {
            throw new JwtException("An error occurred while attempting to decode the Jwt: " + ex.getMessage(), ex);
        }
    }

    private Jwt createJwt(String token, JWT parsedJwt) {
        Jwt jwt;
        try {
            JWTClaimsSet jwtClaimsSet = this.jwtProcessor.process(parsedJwt, null);
            Instant expiresAt = null;
            if (jwtClaimsSet.getExpirationTime() != null) {
                expiresAt = jwtClaimsSet.getExpirationTime().toInstant();
            }
            Instant issuedAt = null;
            if (jwtClaimsSet.getIssueTime() != null) {
                issuedAt = jwtClaimsSet.getIssueTime().toInstant();
            } else if (expiresAt != null) {
                issuedAt = Instant.from(expiresAt).minusSeconds(1L);
            }
            LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>((Map<String, Object>)parsedJwt.getHeader().toJSONObject());
            jwt = new Jwt(token, issuedAt, expiresAt, headers, jwtClaimsSet.getClaims());
        }
        catch (Exception ex) {
            throw new JwtException("An error occurred while attempting to decode the Jwt: " + ex.getMessage(), ex);
        }
        return jwt;
    }
}

