/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.jackson;

import org.springframework.security.oauth2.client.jackson.JsonNodeUtils;
import org.springframework.security.oauth2.client.jackson.StdConverters;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import tools.jackson.core.JsonParser;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.util.StdConverter;

final class OAuth2AuthorizationRequestDeserializer
extends ValueDeserializer<OAuth2AuthorizationRequest> {
    private static final StdConverter<JsonNode, AuthorizationGrantType> AUTHORIZATION_GRANT_TYPE_CONVERTER = new StdConverters.AuthorizationGrantTypeConverter();

    OAuth2AuthorizationRequestDeserializer() {
    }

    public OAuth2AuthorizationRequest deserialize(JsonParser parser, DeserializationContext context) {
        JsonNode root = context.readTree(parser);
        return this.deserialize(parser, context, root);
    }

    private OAuth2AuthorizationRequest deserialize(JsonParser parser, DeserializationContext context, JsonNode root) {
        AuthorizationGrantType authorizationGrantType = (AuthorizationGrantType)AUTHORIZATION_GRANT_TYPE_CONVERTER.convert((Object)JsonNodeUtils.findObjectNode(root, "authorizationGrantType"));
        OAuth2AuthorizationRequest.Builder builder = this.getBuilder(parser, authorizationGrantType);
        builder.authorizationUri(JsonNodeUtils.findStringValue(root, "authorizationUri"));
        builder.clientId(JsonNodeUtils.findStringValue(root, "clientId"));
        builder.redirectUri(JsonNodeUtils.findStringValue(root, "redirectUri"));
        builder.scopes(JsonNodeUtils.findValue(root, "scopes", JsonNodeUtils.STRING_SET, context));
        builder.state(JsonNodeUtils.findStringValue(root, "state"));
        builder.additionalParameters(JsonNodeUtils.findValue(root, "additionalParameters", JsonNodeUtils.STRING_OBJECT_MAP, context));
        builder.authorizationRequestUri(JsonNodeUtils.findStringValue(root, "authorizationRequestUri"));
        builder.attributes(JsonNodeUtils.findValue(root, "attributes", JsonNodeUtils.STRING_OBJECT_MAP, context));
        return builder.build();
    }

    private OAuth2AuthorizationRequest.Builder getBuilder(JsonParser parser, AuthorizationGrantType authorizationGrantType) {
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)authorizationGrantType)) {
            return OAuth2AuthorizationRequest.authorizationCode();
        }
        throw new StreamReadException(parser, "Invalid authorizationGrantType");
    }
}

