/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.authentication;

import java.util.function.Function;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.ReactiveOAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationExchange;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class OAuth2AuthorizationCodeReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private static final String INVALID_STATE_PARAMETER_ERROR_CODE = "invalid_state_parameter";
    private final ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;

    public OAuth2AuthorizationCodeReactiveAuthenticationManager(ReactiveOAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient) {
        Assert.notNull(accessTokenResponseClient, (String)"accessTokenResponseClient cannot be null");
        this.accessTokenResponseClient = accessTokenResponseClient;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        return Mono.defer(() -> {
            OAuth2AuthorizationCodeAuthenticationToken token = (OAuth2AuthorizationCodeAuthenticationToken)authentication;
            OAuth2AuthorizationResponse authorizationResponse = token.getAuthorizationExchange().getAuthorizationResponse();
            if (authorizationResponse.statusError()) {
                return Mono.error((Throwable)new OAuth2AuthorizationException(authorizationResponse.getError()));
            }
            OAuth2AuthorizationRequest authorizationRequest = token.getAuthorizationExchange().getAuthorizationRequest();
            if (!authorizationResponse.getState().equals(authorizationRequest.getState())) {
                OAuth2Error oauth2Error = new OAuth2Error(INVALID_STATE_PARAMETER_ERROR_CODE);
                return Mono.error((Throwable)new OAuth2AuthorizationException(oauth2Error));
            }
            OAuth2AuthorizationCodeGrantRequest authzRequest = new OAuth2AuthorizationCodeGrantRequest(token.getClientRegistration(), token.getAuthorizationExchange());
            return this.accessTokenResponseClient.getTokenResponse(authzRequest).map(this.onSuccess(token));
        });
    }

    private Function<OAuth2AccessTokenResponse, OAuth2AuthorizationCodeAuthenticationToken> onSuccess(OAuth2AuthorizationCodeAuthenticationToken token) {
        return accessTokenResponse -> {
            ClientRegistration registration = token.getClientRegistration();
            OAuth2AuthorizationExchange exchange = token.getAuthorizationExchange();
            OAuth2AccessToken accessToken = accessTokenResponse.getAccessToken();
            OAuth2RefreshToken refreshToken = accessTokenResponse.getRefreshToken();
            return new OAuth2AuthorizationCodeAuthenticationToken(registration, exchange, accessToken, refreshToken, accessTokenResponse.getAdditionalParameters());
        };
    }
}

