/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.server.ServerOAuth2AuthorizedClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class DefaultReactiveOAuth2AuthorizedClientManager
implements ReactiveOAuth2AuthorizedClientManager {
    private final ReactiveClientRegistrationRepository clientRegistrationRepository;
    private final ServerOAuth2AuthorizedClientRepository authorizedClientRepository;
    private ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider = context -> Mono.empty();
    private Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> contextAttributesMapper = new DefaultContextAttributesMapper();

    public DefaultReactiveOAuth2AuthorizedClientManager(ReactiveClientRegistrationRepository clientRegistrationRepository, ServerOAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientRepository = authorizedClientRepository;
    }

    @Override
    public Mono<OAuth2AuthorizedClient> authorize(OAuth2AuthorizeRequest authorizeRequest) {
        Assert.notNull((Object)authorizeRequest, (String)"authorizeRequest cannot be null");
        String clientRegistrationId = authorizeRequest.getClientRegistrationId();
        Authentication principal = authorizeRequest.getPrincipal();
        ServerWebExchange serverWebExchange = (ServerWebExchange)authorizeRequest.getAttribute(ServerWebExchange.class.getName());
        return Mono.justOrEmpty((Object)authorizeRequest.getAuthorizedClient()).switchIfEmpty(Mono.defer(() -> this.loadAuthorizedClient(clientRegistrationId, principal, serverWebExchange))).flatMap(authorizedClient -> this.authorizationContext(authorizeRequest, (OAuth2AuthorizedClient)authorizedClient).flatMap(this.authorizedClientProvider::authorize).flatMap(reauthorizedClient -> this.saveAuthorizedClient((OAuth2AuthorizedClient)reauthorizedClient, principal, serverWebExchange)).defaultIfEmpty((Object)(authorizeRequest.getAuthorizedClient() != null ? authorizeRequest.getAuthorizedClient() : authorizedClient))).switchIfEmpty(Mono.deferWithContext(context -> this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId).switchIfEmpty(Mono.error(() -> new IllegalArgumentException("Could not find ClientRegistration with id '" + clientRegistrationId + "'"))).flatMap(clientRegistration -> this.authorizationContext(authorizeRequest, (ClientRegistration)clientRegistration)).flatMap(this.authorizedClientProvider::authorize).flatMap(authorizedClient -> this.saveAuthorizedClient((OAuth2AuthorizedClient)authorizedClient, principal, serverWebExchange)).subscriberContext(context)));
    }

    private Mono<OAuth2AuthorizedClient> loadAuthorizedClient(String clientRegistrationId, Authentication principal, ServerWebExchange serverWebExchange) {
        return Mono.justOrEmpty((Object)serverWebExchange).switchIfEmpty(Mono.defer(() -> DefaultReactiveOAuth2AuthorizedClientManager.currentServerWebExchange())).flatMap(exchange -> this.authorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal, (ServerWebExchange)exchange));
    }

    private Mono<OAuth2AuthorizedClient> saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal, ServerWebExchange serverWebExchange) {
        return Mono.justOrEmpty((Object)serverWebExchange).switchIfEmpty(Mono.defer(() -> DefaultReactiveOAuth2AuthorizedClientManager.currentServerWebExchange())).map(exchange -> {
            this.authorizedClientRepository.saveAuthorizedClient(authorizedClient, principal, (ServerWebExchange)exchange);
            return authorizedClient;
        }).defaultIfEmpty((Object)authorizedClient);
    }

    private static Mono<ServerWebExchange> currentServerWebExchange() {
        return Mono.subscriberContext().filter(c -> c.hasKey(ServerWebExchange.class)).map(c -> (ServerWebExchange)c.get(ServerWebExchange.class));
    }

    private Mono<OAuth2AuthorizationContext> authorizationContext(OAuth2AuthorizeRequest authorizeRequest, OAuth2AuthorizedClient authorizedClient) {
        return Mono.just((Object)authorizeRequest).flatMap(this.contextAttributesMapper::apply).map(attrs -> OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient).principal(authorizeRequest.getPrincipal()).attributes(attributes -> {
            if (!CollectionUtils.isEmpty((Map)attrs)) {
                attributes.putAll(attrs);
            }
        }).build());
    }

    private Mono<OAuth2AuthorizationContext> authorizationContext(OAuth2AuthorizeRequest authorizeRequest, ClientRegistration clientRegistration) {
        return Mono.just((Object)authorizeRequest).flatMap(this.contextAttributesMapper::apply).map(attrs -> OAuth2AuthorizationContext.withClientRegistration(clientRegistration).principal(authorizeRequest.getPrincipal()).attributes(attributes -> {
            if (!CollectionUtils.isEmpty((Map)attrs)) {
                attributes.putAll(attrs);
            }
        }).build());
    }

    public void setAuthorizedClientProvider(ReactiveOAuth2AuthorizedClientProvider authorizedClientProvider) {
        Assert.notNull((Object)authorizedClientProvider, (String)"authorizedClientProvider cannot be null");
        this.authorizedClientProvider = authorizedClientProvider;
    }

    public void setContextAttributesMapper(Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> contextAttributesMapper) {
        Assert.notNull(contextAttributesMapper, (String)"contextAttributesMapper cannot be null");
        this.contextAttributesMapper = contextAttributesMapper;
    }

    public static class DefaultContextAttributesMapper
    implements Function<OAuth2AuthorizeRequest, Mono<Map<String, Object>>> {
        @Override
        public Mono<Map<String, Object>> apply(OAuth2AuthorizeRequest authorizeRequest) {
            ServerWebExchange serverWebExchange = (ServerWebExchange)authorizeRequest.getAttribute(ServerWebExchange.class.getName());
            return Mono.justOrEmpty((Object)serverWebExchange).switchIfEmpty(Mono.defer(() -> DefaultReactiveOAuth2AuthorizedClientManager.currentServerWebExchange())).flatMap(exchange -> {
                Map<String, String[]> contextAttributes = Collections.emptyMap();
                String scope = (String)exchange.getRequest().getQueryParams().getFirst((Object)"scope");
                if (StringUtils.hasText((String)scope)) {
                    contextAttributes = new HashMap();
                    contextAttributes.put(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME, StringUtils.delimitedListToStringArray((String)scope, (String)" "));
                }
                return Mono.just(contextAttributes);
            }).defaultIfEmpty(Collections.emptyMap());
        }
    }
}

