/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.server;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.oauth2.client.web.server.ServerAuthorizationRequestRepository;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Mono;

public final class WebSessionOAuth2ServerAuthorizationRequestRepository
implements ServerAuthorizationRequestRepository<OAuth2AuthorizationRequest> {
    private static final String DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME = WebSessionOAuth2ServerAuthorizationRequestRepository.class.getName() + ".AUTHORIZATION_REQUEST";
    private final String sessionAttributeName = DEFAULT_AUTHORIZATION_REQUEST_ATTR_NAME;

    @Override
    public Mono<OAuth2AuthorizationRequest> loadAuthorizationRequest(ServerWebExchange exchange) {
        String state = this.getStateParameter(exchange);
        if (state == null) {
            return Mono.empty();
        }
        return this.getStateToAuthorizationRequest(exchange).filter(stateToAuthorizationRequest -> stateToAuthorizationRequest.containsKey(state)).map(stateToAuthorizationRequest -> (OAuth2AuthorizationRequest)stateToAuthorizationRequest.get(state));
    }

    @Override
    public Mono<Void> saveAuthorizationRequest(OAuth2AuthorizationRequest authorizationRequest, ServerWebExchange exchange) {
        Assert.notNull((Object)authorizationRequest, (String)"authorizationRequest cannot be null");
        return this.saveStateToAuthorizationRequest(exchange).doOnNext(stateToAuthorizationRequest -> stateToAuthorizationRequest.put(authorizationRequest.getState(), authorizationRequest)).then();
    }

    @Override
    public Mono<OAuth2AuthorizationRequest> removeAuthorizationRequest(ServerWebExchange exchange) {
        String state = this.getStateParameter(exchange);
        if (state == null) {
            return Mono.empty();
        }
        return exchange.getSession().map(WebSession::getAttributes).handle((sessionAttrs, sink) -> {
            Map<String, OAuth2AuthorizationRequest> stateToAuthzRequest = this.sessionAttrsMapStateToAuthorizationRequest((Map<String, Object>)sessionAttrs);
            if (stateToAuthzRequest == null) {
                sink.complete();
                return;
            }
            OAuth2AuthorizationRequest removedValue = stateToAuthzRequest.remove(state);
            if (stateToAuthzRequest.isEmpty()) {
                sessionAttrs.remove(this.sessionAttributeName);
            }
            if (removedValue == null) {
                sink.complete();
            } else {
                sink.next((Object)removedValue);
            }
        });
    }

    private String getStateParameter(ServerWebExchange exchange) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return (String)exchange.getRequest().getQueryParams().getFirst((Object)"state");
    }

    private Mono<Map<String, Object>> getSessionAttributes(ServerWebExchange exchange) {
        return exchange.getSession().map(WebSession::getAttributes);
    }

    private Mono<Map<String, OAuth2AuthorizationRequest>> getStateToAuthorizationRequest(ServerWebExchange exchange) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return this.getSessionAttributes(exchange).flatMap(sessionAttrs -> Mono.justOrEmpty(this.sessionAttrsMapStateToAuthorizationRequest((Map<String, Object>)sessionAttrs)));
    }

    private Mono<Map<String, OAuth2AuthorizationRequest>> saveStateToAuthorizationRequest(ServerWebExchange exchange) {
        Assert.notNull((Object)exchange, (String)"exchange cannot be null");
        return this.getSessionAttributes(exchange).doOnNext(sessionAttrs -> {
            Object stateToAuthzRequest = sessionAttrs.get(this.sessionAttributeName);
            if (stateToAuthzRequest == null) {
                stateToAuthzRequest = new HashMap();
            }
            sessionAttrs.put(this.sessionAttributeName, stateToAuthzRequest);
        }).flatMap(sessionAttrs -> Mono.justOrEmpty(this.sessionAttrsMapStateToAuthorizationRequest((Map<String, Object>)sessionAttrs)));
    }

    private Map<String, OAuth2AuthorizationRequest> sessionAttrsMapStateToAuthorizationRequest(Map<String, Object> sessionAttrs) {
        return (Map)sessionAttrs.get(this.sessionAttributeName);
    }
}

