/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.registration;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.util.Assert;

public final class InMemoryClientRegistrationRepository
implements ClientRegistrationRepository,
Iterable<ClientRegistration> {
    private final Map<String, ClientRegistration> registrations;

    public InMemoryClientRegistrationRepository(ClientRegistration ... registrations) {
        this(Arrays.asList(registrations));
    }

    public InMemoryClientRegistrationRepository(List<ClientRegistration> registrations) {
        Assert.notEmpty(registrations, (String)"registrations cannot be empty");
        Collector collector = Collectors.toConcurrentMap(ClientRegistration::getRegistrationId, Function.identity());
        this.registrations = registrations.stream().collect(Collectors.collectingAndThen(collector, Collections::unmodifiableMap));
    }

    @Override
    public ClientRegistration findByRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return this.registrations.get(registrationId);
    }

    @Override
    public Iterator<ClientRegistration> iterator() {
        return this.registrations.values().iterator();
    }
}

