/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.oidc.userinfo;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.security.oauth2.client.oidc.userinfo.NimbusUserInfoResponseClient;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final String INVALID_USER_INFO_RESPONSE_ERROR_CODE = "invalid_user_info_response";
    private final Set<String> userInfoScopes = new HashSet<String>(Arrays.asList("profile", "email", "address", "phone"));
    private NimbusUserInfoResponseClient userInfoResponseClient = new NimbusUserInfoResponseClient();

    @Override
    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        ParameterizedTypeReference<Map<String, Object>> typeReference;
        Map<String, Object> userAttributes;
        Assert.notNull((Object)userRequest, (String)"userRequest cannot be null");
        OidcUserInfo userInfo = null;
        if (this.shouldRetrieveUserInfo(userRequest) && !(userInfo = new OidcUserInfo(userAttributes = this.userInfoResponseClient.getUserInfoResponse((OAuth2UserRequest)userRequest, typeReference = new ParameterizedTypeReference<Map<String, Object>>(){}))).getSubject().equals(userRequest.getIdToken().getSubject())) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_USER_INFO_RESPONSE_ERROR_CODE);
            throw new OAuth2AuthenticationException(oauth2Error, oauth2Error.toString());
        }
        OidcUserAuthority authority = new OidcUserAuthority(userRequest.getIdToken(), userInfo);
        HashSet<OidcUserAuthority> authorities = new HashSet<OidcUserAuthority>();
        authorities.add(authority);
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        DefaultOidcUser user = StringUtils.hasText((String)userNameAttributeName) ? new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo, userNameAttributeName) : new DefaultOidcUser(authorities, userRequest.getIdToken(), userInfo);
        return user;
    }

    private boolean shouldRetrieveUserInfo(OidcUserRequest userRequest) {
        if (StringUtils.isEmpty((Object)userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUri())) {
            return false;
        }
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)userRequest.getClientRegistration().getAuthorizationGrantType())) {
            return userRequest.getAccessToken().getScopes().stream().anyMatch(this.userInfoScopes::contains);
        }
        return false;
    }
}

