/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.converter;

import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.server.authorization.OAuth2ClientRegistration;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.util.CollectionUtils;

public final class OAuth2ClientRegistrationRegisteredClientConverter
implements Converter<OAuth2ClientRegistration, RegisteredClient> {
    private static final StringKeyGenerator CLIENT_ID_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 32);
    private static final StringKeyGenerator CLIENT_SECRET_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 48);

    public RegisteredClient convert(OAuth2ClientRegistration clientRegistration) {
        RegisteredClient.Builder builder = RegisteredClient.withId(UUID.randomUUID().toString()).clientId(CLIENT_ID_GENERATOR.generateKey()).clientIdIssuedAt(Instant.now()).clientName(clientRegistration.getClientName());
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).clientSecret(CLIENT_SECRET_GENERATOR.generateKey());
        } else if (ClientAuthenticationMethod.NONE.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.NONE);
        } else {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).clientSecret(CLIENT_SECRET_GENERATOR.generateKey());
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getRedirectUris())) {
            builder.redirectUris(redirectUris -> redirectUris.addAll(clientRegistration.getRedirectUris()));
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getGrantTypes())) {
            builder.authorizationGrantTypes(authorizationGrantTypes -> clientRegistration.getGrantTypes().forEach(grantType -> authorizationGrantTypes.add(new AuthorizationGrantType(grantType))));
        } else {
            builder.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getResponseTypes()) && clientRegistration.getResponseTypes().contains(OAuth2AuthorizationResponseType.CODE.getValue())) {
            builder.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            builder.scopes(scopes -> scopes.addAll(clientRegistration.getScopes()));
        }
        ClientSettings.Builder clientSettingsBuilder = ClientSettings.builder().requireProofKey(true).requireAuthorizationConsent(true);
        if (clientRegistration.getJwkSetUrl() != null) {
            clientSettingsBuilder.jwkSetUrl(clientRegistration.getJwkSetUrl().toString());
        }
        builder.clientSettings(clientSettingsBuilder.build());
        return builder.build();
    }
}

