/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2AuthorizationConsent
implements Serializable {
    private static final long serialVersionUID = -1950648027021276018L;
    private static final String AUTHORITIES_SCOPE_PREFIX = "SCOPE_";
    private final String registeredClientId;
    private final String principalName;
    private final Set<GrantedAuthority> authorities;

    private OAuth2AuthorizationConsent(String registeredClientId, String principalName, Set<GrantedAuthority> authorities) {
        this.registeredClientId = registeredClientId;
        this.principalName = principalName;
        this.authorities = Collections.unmodifiableSet(authorities);
    }

    public String getRegisteredClientId() {
        return this.registeredClientId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public Set<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Set<String> getScopes() {
        HashSet<String> authorities = new HashSet<String>();
        for (GrantedAuthority authority : this.getAuthorities()) {
            if (!authority.getAuthority().startsWith(AUTHORITIES_SCOPE_PREFIX)) continue;
            authorities.add(authority.getAuthority().substring(AUTHORITIES_SCOPE_PREFIX.length()));
        }
        return authorities;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2AuthorizationConsent that = (OAuth2AuthorizationConsent)obj;
        return Objects.equals(this.registeredClientId, that.registeredClientId) && Objects.equals(this.principalName, that.principalName) && Objects.equals(this.authorities, that.authorities);
    }

    public int hashCode() {
        return Objects.hash(this.registeredClientId, this.principalName, this.authorities);
    }

    public static Builder from(OAuth2AuthorizationConsent authorizationConsent) {
        Assert.notNull((Object)authorizationConsent, (String)"authorizationConsent cannot be null");
        return new Builder(authorizationConsent.getRegisteredClientId(), authorizationConsent.getPrincipalName(), authorizationConsent.getAuthorities());
    }

    public static Builder withId(@NonNull String registeredClientId, @NonNull String principalName) {
        Assert.hasText((String)registeredClientId, (String)"registeredClientId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        return new Builder(registeredClientId, principalName);
    }

    public static final class Builder {
        private final String registeredClientId;
        private final String principalName;
        private final Set<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();

        private Builder(String registeredClientId, String principalName) {
            this(registeredClientId, principalName, Collections.emptySet());
        }

        private Builder(String registeredClientId, String principalName, Set<GrantedAuthority> authorities) {
            this.registeredClientId = registeredClientId;
            this.principalName = principalName;
            if (!CollectionUtils.isEmpty(authorities)) {
                this.authorities.addAll(authorities);
            }
        }

        public Builder scope(String scope) {
            this.authority((GrantedAuthority)new SimpleGrantedAuthority(OAuth2AuthorizationConsent.AUTHORITIES_SCOPE_PREFIX + scope));
            return this;
        }

        public Builder authority(GrantedAuthority authority) {
            this.authorities.add(authority);
            return this;
        }

        public Builder authorities(Consumer<Set<GrantedAuthority>> authoritiesConsumer) {
            authoritiesConsumer.accept(this.authorities);
            return this;
        }

        public OAuth2AuthorizationConsent build() {
            Assert.notEmpty(this.authorities, (String)"authorities cannot be empty");
            return new OAuth2AuthorizationConsent(this.registeredClientId, this.principalName, this.authorities);
        }
    }
}

