/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.http.converter;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.SmartHttpMessageConverter;

final class GenericHttpMessageConverterAdapter<T>
implements GenericHttpMessageConverter<T> {
    private final SmartHttpMessageConverter<T> smartConverter;

    GenericHttpMessageConverterAdapter(SmartHttpMessageConverter<T> smartConverter) {
        this.smartConverter = smartConverter;
    }

    public boolean canRead(Type type, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
        return this.smartConverter.canRead(ResolvableType.forType((Type)type), mediaType);
    }

    public T read(Type type, @Nullable Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return (T)this.smartConverter.read(ResolvableType.forType((Type)type), inputMessage, null);
    }

    public boolean canWrite(@Nullable Type type, Class<?> clazz, @Nullable MediaType mediaType) {
        return this.smartConverter.canWrite(ResolvableType.forType((Type)type), clazz, mediaType);
    }

    public void write(T t, @Nullable Type type, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.smartConverter.write(t, ResolvableType.forType((Type)type), contentType, outputMessage, null);
    }

    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.smartConverter.canRead(ResolvableType.forClass(clazz), mediaType);
    }

    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.smartConverter.canWrite(clazz, mediaType);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.smartConverter.getSupportedMediaTypes();
    }

    public T read(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return (T)this.smartConverter.read(clazz, inputMessage);
    }

    public void write(T t, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.smartConverter.write(t, contentType, outputMessage);
    }
}

