/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.OAuth2ClientRegistration;
import org.springframework.util.Assert;

public class OAuth2ClientRegistrationAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 7135429161909989115L;
    @Nullable
    private final Authentication principal;
    private final OAuth2ClientRegistration clientRegistration;

    public OAuth2ClientRegistrationAuthenticationToken(@Nullable Authentication principal, OAuth2ClientRegistration clientRegistration) {
        super(Collections.emptyList());
        Assert.notNull((Object)clientRegistration, (String)"clientRegistration cannot be null");
        this.principal = principal;
        this.clientRegistration = clientRegistration;
        if (principal != null) {
            this.setAuthenticated(principal.isAuthenticated());
        }
    }

    @Nullable
    public Object getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return "";
    }

    public OAuth2ClientRegistration getClientRegistration() {
        return this.clientRegistration;
    }
}

