/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.authentication;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcAuthenticationProviderUtils;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.converter.OidcClientRegistrationRegisteredClientConverter;
import org.springframework.security.oauth2.server.authorization.oidc.converter.RegisteredClientOidcClientRegistrationConverter;
import org.springframework.security.oauth2.server.authorization.token.DefaultOAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class OidcClientRegistrationAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://openid.net/specs/openid-connect-registration-1_0.html#RegistrationError";
    private static final String DEFAULT_CLIENT_REGISTRATION_AUTHORIZED_SCOPE = "client.create";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator;
    private Converter<RegisteredClient, OidcClientRegistration> clientRegistrationConverter;
    private Converter<OidcClientRegistration, RegisteredClient> registeredClientConverter;
    private PasswordEncoder passwordEncoder;

    public OidcClientRegistrationAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService, OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.notNull(tokenGenerator, (String)"tokenGenerator cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        this.tokenGenerator = tokenGenerator;
        this.clientRegistrationConverter = new RegisteredClientOidcClientRegistrationConverter();
        this.registeredClientConverter = new OidcClientRegistrationRegisteredClientConverter();
        this.passwordEncoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken;
        OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication = (OidcClientRegistrationAuthenticationToken)authentication;
        if (clientRegistrationAuthentication.getClientRegistration() == null) {
            return null;
        }
        AbstractOAuth2TokenAuthenticationToken accessTokenAuthentication = null;
        if (AbstractOAuth2TokenAuthenticationToken.class.isAssignableFrom(clientRegistrationAuthentication.getPrincipal().getClass())) {
            accessTokenAuthentication = (AbstractOAuth2TokenAuthenticationToken)clientRegistrationAuthentication.getPrincipal();
        }
        if (accessTokenAuthentication == null || !accessTokenAuthentication.isAuthenticated()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        String accessTokenValue = accessTokenAuthentication.getToken().getTokenValue();
        OAuth2Authorization authorization = this.authorizationService.findByToken(accessTokenValue, OAuth2TokenType.ACCESS_TOKEN);
        if (authorization == null) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved authorization with initial access token");
        }
        if (!(authorizedAccessToken = authorization.getAccessToken()).isActive()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        OidcClientRegistrationAuthenticationProvider.checkScope(authorizedAccessToken, Collections.singleton(DEFAULT_CLIENT_REGISTRATION_AUTHORIZED_SCOPE));
        return this.registerClient(clientRegistrationAuthentication, authorization);
    }

    public boolean supports(Class<?> authentication) {
        return OidcClientRegistrationAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setRegisteredClientConverter(Converter<OidcClientRegistration, RegisteredClient> registeredClientConverter) {
        Assert.notNull(registeredClientConverter, (String)"registeredClientConverter cannot be null");
        this.registeredClientConverter = registeredClientConverter;
    }

    public void setClientRegistrationConverter(Converter<RegisteredClient, OidcClientRegistration> clientRegistrationConverter) {
        Assert.notNull(clientRegistrationConverter, (String)"clientRegistrationConverter cannot be null");
        this.clientRegistrationConverter = clientRegistrationConverter;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder cannot be null");
        this.passwordEncoder = passwordEncoder;
    }

    private OidcClientRegistrationAuthenticationToken registerClient(OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication, OAuth2Authorization authorization) {
        RegisteredClient registeredClient;
        if (!OidcClientRegistrationAuthenticationProvider.isValidRedirectUris(clientRegistrationAuthentication.getClientRegistration().getRedirectUris())) {
            OidcClientRegistrationAuthenticationProvider.throwInvalidClientRegistration("invalid_redirect_uri", "redirect_uris");
        }
        if (!OidcClientRegistrationAuthenticationProvider.isValidRedirectUris(clientRegistrationAuthentication.getClientRegistration().getPostLogoutRedirectUris())) {
            OidcClientRegistrationAuthenticationProvider.throwInvalidClientRegistration("invalid_client_metadata", "post_logout_redirect_uris");
        }
        if (!OidcClientRegistrationAuthenticationProvider.isValidTokenEndpointAuthenticationMethod(clientRegistrationAuthentication.getClientRegistration())) {
            OidcClientRegistrationAuthenticationProvider.throwInvalidClientRegistration("invalid_client_metadata", "token_endpoint_auth_method");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated client registration request parameters");
        }
        if (StringUtils.hasText((String)(registeredClient = (RegisteredClient)this.registeredClientConverter.convert((Object)clientRegistrationAuthentication.getClientRegistration())).getClientSecret())) {
            RegisteredClient updatedRegisteredClient = RegisteredClient.from(registeredClient).clientSecret(this.passwordEncoder.encode((CharSequence)registeredClient.getClientSecret())).build();
            this.registeredClientRepository.save(updatedRegisteredClient);
            if (ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue().equals(clientRegistrationAuthentication.getClientRegistration().getTokenEndpointAuthenticationMethod())) {
                registeredClient = updatedRegisteredClient;
            }
        } else {
            this.registeredClientRepository.save(registeredClient);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved registered client");
        }
        OAuth2Authorization registeredClientAuthorization = this.registerAccessToken(registeredClient);
        OAuth2Authorization.Builder builder = OAuth2Authorization.from(authorization).invalidate(authorization.getAccessToken().getToken());
        if (authorization.getRefreshToken() != null) {
            builder.invalidate(authorization.getRefreshToken().getToken());
        }
        authorization = builder.build();
        this.authorizationService.save(authorization);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved authorization with invalidated initial access token");
        }
        Map<String, Object> clientRegistrationClaims = ((OidcClientRegistration)this.clientRegistrationConverter.convert((Object)registeredClient)).getClaims();
        OidcClientRegistration clientRegistration = OidcClientRegistration.withClaims(clientRegistrationClaims).registrationAccessToken(registeredClientAuthorization.getAccessToken().getToken().getTokenValue()).build();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated client registration request");
        }
        OidcClientRegistrationAuthenticationToken clientRegistrationAuthenticationResult = new OidcClientRegistrationAuthenticationToken((Authentication)clientRegistrationAuthentication.getPrincipal(), clientRegistration);
        clientRegistrationAuthenticationResult.setDetails(clientRegistrationAuthentication.getDetails());
        return clientRegistrationAuthenticationResult;
    }

    private OAuth2Authorization registerAccessToken(RegisteredClient registeredClient) {
        OAuth2ClientAuthenticationToken clientPrincipal = new OAuth2ClientAuthenticationToken(registeredClient, registeredClient.getClientAuthenticationMethods().iterator().next(), registeredClient.getClientSecret());
        HashSet<String> authorizedScopes = new HashSet<String>();
        authorizedScopes.add("client.read");
        authorizedScopes = Collections.unmodifiableSet(authorizedScopes);
        DefaultOAuth2TokenContext tokenContext = ((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)DefaultOAuth2TokenContext.builder().registeredClient(registeredClient)).principal((Authentication)clientPrincipal)).authorizationServerContext(AuthorizationServerContextHolder.getContext())).authorizedScopes(authorizedScopes)).tokenType(OAuth2TokenType.ACCESS_TOKEN)).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS)).build();
        OAuth2Token registrationAccessToken = this.tokenGenerator.generate(tokenContext);
        if (registrationAccessToken == null) {
            OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the registration access token.", ERROR_URI);
            throw new OAuth2AuthenticationException(error);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Generated registration access token");
        }
        OAuth2Authorization.Builder authorizationBuilder = OAuth2Authorization.withRegisteredClient(registeredClient).principalName(registeredClient.getClientId()).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).authorizedScopes(authorizedScopes);
        OidcAuthenticationProviderUtils.accessToken(authorizationBuilder, registrationAccessToken, tokenContext);
        OAuth2Authorization authorization = authorizationBuilder.build();
        this.authorizationService.save(authorization);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved authorization with registration access token");
        }
        return authorization;
    }

    private static void checkScope(OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken, Set<String> requiredScope) {
        Collection<Object> authorizedScope = Collections.emptySet();
        if (authorizedAccessToken.getClaims().containsKey("scope")) {
            authorizedScope = (Collection)authorizedAccessToken.getClaims().get("scope");
        }
        if (!authorizedScope.containsAll(requiredScope)) {
            throw new OAuth2AuthenticationException("insufficient_scope");
        }
        if (authorizedScope.size() != requiredScope.size()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
    }

    private static boolean isValidRedirectUris(List<String> redirectUris) {
        if (CollectionUtils.isEmpty(redirectUris)) {
            return true;
        }
        for (String redirectUri : redirectUris) {
            try {
                URI validRedirectUri = new URI(redirectUri);
                if (validRedirectUri.getFragment() == null) continue;
                return false;
            }
            catch (URISyntaxException ex) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidTokenEndpointAuthenticationMethod(OidcClientRegistration clientRegistration) {
        String authenticationMethod = clientRegistration.getTokenEndpointAuthenticationMethod();
        String authenticationSigningAlgorithm = clientRegistration.getTokenEndpointAuthenticationSigningAlgorithm();
        if (!ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue().equals(authenticationMethod) && !ClientAuthenticationMethod.CLIENT_SECRET_JWT.getValue().equals(authenticationMethod)) {
            return !StringUtils.hasText((String)authenticationSigningAlgorithm);
        }
        if ("none".equals(authenticationSigningAlgorithm)) {
            return false;
        }
        if (ClientAuthenticationMethod.PRIVATE_KEY_JWT.getValue().equals(authenticationMethod)) {
            return clientRegistration.getJwkSetUrl() != null && (!StringUtils.hasText((String)authenticationSigningAlgorithm) || SignatureAlgorithm.from((String)authenticationSigningAlgorithm) != null);
        }
        return !StringUtils.hasText((String)authenticationSigningAlgorithm) || MacAlgorithm.from((String)authenticationSigningAlgorithm) != null;
    }

    private static void throwInvalidClientRegistration(String errorCode, String fieldName) {
        OAuth2Error error = new OAuth2Error(errorCode, "Invalid Client Registration: " + fieldName, ERROR_URI);
        throw new OAuth2AuthenticationException(error);
    }
}

