/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.time.Instant;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.AbstractOAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.util.Assert;

public class OAuth2PushedAuthorizationRequestAuthenticationToken
extends AbstractOAuth2AuthorizationCodeRequestAuthenticationToken {
    private static final long serialVersionUID = 7330534287786569644L;
    private final String requestUri;
    private final Instant requestUriExpiresAt;

    public OAuth2PushedAuthorizationRequestAuthenticationToken(String authorizationUri, String clientId, Authentication principal, @Nullable String redirectUri, @Nullable String state, @Nullable Set<String> scopes, @Nullable Map<String, Object> additionalParameters) {
        super(authorizationUri, clientId, principal, redirectUri, state, scopes, additionalParameters);
        this.requestUri = null;
        this.requestUriExpiresAt = null;
    }

    public OAuth2PushedAuthorizationRequestAuthenticationToken(String authorizationUri, String clientId, Authentication principal, String requestUri, Instant requestUriExpiresAt, @Nullable String redirectUri, @Nullable String state, @Nullable Set<String> scopes) {
        super(authorizationUri, clientId, principal, redirectUri, state, scopes, null);
        Assert.hasText((String)requestUri, (String)"requestUri cannot be empty");
        Assert.notNull((Object)requestUriExpiresAt, (String)"requestUriExpiresAt cannot be null");
        this.requestUri = requestUri;
        this.requestUriExpiresAt = requestUriExpiresAt;
        this.setAuthenticated(true);
    }

    @Nullable
    public String getRequestUri() {
        return this.requestUri;
    }

    @Nullable
    public Instant getRequestUriExpiresAt() {
        return this.requestUriExpiresAt;
    }
}

