/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AbstractOAuth2Configurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ConfigurerUtils;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcUserInfoAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcUserInfoEndpointFilter;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationConverter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OidcUserInfoEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private final List<AuthenticationConverter> userInfoRequestConverters = new ArrayList<AuthenticationConverter>();
    private Consumer<List<AuthenticationConverter>> userInfoRequestConvertersConsumer = userInfoRequestConverters -> {};
    private final List<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
    private Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer = authenticationProviders -> {};
    private AuthenticationSuccessHandler userInfoResponseHandler;
    private AuthenticationFailureHandler errorResponseHandler;
    private Function<OidcUserInfoAuthenticationContext, OidcUserInfo> userInfoMapper;

    OidcUserInfoEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OidcUserInfoEndpointConfigurer userInfoRequestConverter(AuthenticationConverter userInfoRequestConverter) {
        Assert.notNull((Object)userInfoRequestConverter, (String)"userInfoRequestConverter cannot be null");
        this.userInfoRequestConverters.add(userInfoRequestConverter);
        return this;
    }

    public OidcUserInfoEndpointConfigurer userInfoRequestConverters(Consumer<List<AuthenticationConverter>> userInfoRequestConvertersConsumer) {
        Assert.notNull(userInfoRequestConvertersConsumer, (String)"userInfoRequestConvertersConsumer cannot be null");
        this.userInfoRequestConvertersConsumer = userInfoRequestConvertersConsumer;
        return this;
    }

    public OidcUserInfoEndpointConfigurer authenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider cannot be null");
        this.authenticationProviders.add(authenticationProvider);
        return this;
    }

    public OidcUserInfoEndpointConfigurer authenticationProviders(Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer) {
        Assert.notNull(authenticationProvidersConsumer, (String)"authenticationProvidersConsumer cannot be null");
        this.authenticationProvidersConsumer = authenticationProvidersConsumer;
        return this;
    }

    public OidcUserInfoEndpointConfigurer userInfoResponseHandler(AuthenticationSuccessHandler userInfoResponseHandler) {
        this.userInfoResponseHandler = userInfoResponseHandler;
        return this;
    }

    public OidcUserInfoEndpointConfigurer errorResponseHandler(AuthenticationFailureHandler errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    public OidcUserInfoEndpointConfigurer userInfoMapper(Function<OidcUserInfoAuthenticationContext, OidcUserInfo> userInfoMapper) {
        this.userInfoMapper = userInfoMapper;
        return this;
    }

    @Override
    void init(HttpSecurity httpSecurity) {
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        String userInfoEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getOidcUserInfoEndpoint()) : authorizationServerSettings.getOidcUserInfoEndpoint();
        this.requestMatcher = new OrRequestMatcher(new RequestMatcher[]{PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, userInfoEndpointUri), PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, userInfoEndpointUri)});
        List<AuthenticationProvider> authenticationProviders = this.createDefaultAuthenticationProviders(httpSecurity);
        if (!this.authenticationProviders.isEmpty()) {
            authenticationProviders.addAll(0, this.authenticationProviders);
        }
        this.authenticationProvidersConsumer.accept(authenticationProviders);
        authenticationProviders.forEach(authenticationProvider -> httpSecurity.authenticationProvider(this.postProcess(authenticationProvider)));
    }

    @Override
    void configure(HttpSecurity httpSecurity) {
        AuthenticationManager authenticationManager = (AuthenticationManager)httpSecurity.getSharedObject(AuthenticationManager.class);
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        String userInfoEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getOidcUserInfoEndpoint()) : authorizationServerSettings.getOidcUserInfoEndpoint();
        OidcUserInfoEndpointFilter oidcUserInfoEndpointFilter = new OidcUserInfoEndpointFilter(authenticationManager, userInfoEndpointUri);
        List<AuthenticationConverter> authenticationConverters = OidcUserInfoEndpointConfigurer.createDefaultAuthenticationConverters();
        if (!this.userInfoRequestConverters.isEmpty()) {
            authenticationConverters.addAll(0, this.userInfoRequestConverters);
        }
        this.userInfoRequestConvertersConsumer.accept(authenticationConverters);
        oidcUserInfoEndpointFilter.setAuthenticationConverter((AuthenticationConverter)new DelegatingAuthenticationConverter(authenticationConverters));
        if (this.userInfoResponseHandler != null) {
            oidcUserInfoEndpointFilter.setAuthenticationSuccessHandler(this.userInfoResponseHandler);
        }
        if (this.errorResponseHandler != null) {
            oidcUserInfoEndpointFilter.setAuthenticationFailureHandler(this.errorResponseHandler);
        }
        httpSecurity.addFilterAfter((Filter)this.postProcess(oidcUserInfoEndpointFilter), AuthorizationFilter.class);
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    private static List<AuthenticationConverter> createDefaultAuthenticationConverters() {
        ArrayList<AuthenticationConverter> authenticationConverters = new ArrayList<AuthenticationConverter>();
        authenticationConverters.add(request -> {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            return new OidcUserInfoAuthenticationToken(authentication);
        });
        return authenticationConverters;
    }

    private List<AuthenticationProvider> createDefaultAuthenticationProviders(HttpSecurity httpSecurity) {
        ArrayList<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
        OidcUserInfoAuthenticationProvider oidcUserInfoAuthenticationProvider = new OidcUserInfoAuthenticationProvider(OAuth2ConfigurerUtils.getAuthorizationService(httpSecurity));
        if (this.userInfoMapper != null) {
            oidcUserInfoAuthenticationProvider.setUserInfoMapper(this.userInfoMapper);
        }
        authenticationProviders.add(oidcUserInfoAuthenticationProvider);
        return authenticationProviders;
    }
}

