/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceAuthorizationRequestAuthenticationProvider;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.AbstractOAuth2Configurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ConfigurerUtils;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.web.OAuth2DeviceAuthorizationEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2DeviceAuthorizationRequestAuthenticationConverter;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationConverter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OAuth2DeviceAuthorizationEndpointConfigurer
extends AbstractOAuth2Configurer {
    private RequestMatcher requestMatcher;
    private final List<AuthenticationConverter> deviceAuthorizationRequestConverters = new ArrayList<AuthenticationConverter>();
    private Consumer<List<AuthenticationConverter>> deviceAuthorizationRequestConvertersConsumer = deviceAuthorizationRequestConverters -> {};
    private final List<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
    private Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer = authenticationProviders -> {};
    private AuthenticationSuccessHandler deviceAuthorizationResponseHandler;
    private AuthenticationFailureHandler errorResponseHandler;
    private String verificationUri;

    OAuth2DeviceAuthorizationEndpointConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
    }

    public OAuth2DeviceAuthorizationEndpointConfigurer deviceAuthorizationRequestConverter(AuthenticationConverter deviceAuthorizationRequestConverter) {
        Assert.notNull((Object)deviceAuthorizationRequestConverter, (String)"deviceAuthorizationRequestConverter cannot be null");
        this.deviceAuthorizationRequestConverters.add(deviceAuthorizationRequestConverter);
        return this;
    }

    public OAuth2DeviceAuthorizationEndpointConfigurer deviceAuthorizationRequestConverters(Consumer<List<AuthenticationConverter>> deviceAuthorizationRequestConvertersConsumer) {
        Assert.notNull(deviceAuthorizationRequestConvertersConsumer, (String)"deviceAuthorizationRequestConvertersConsumer cannot be null");
        this.deviceAuthorizationRequestConvertersConsumer = deviceAuthorizationRequestConvertersConsumer;
        return this;
    }

    public OAuth2DeviceAuthorizationEndpointConfigurer authenticationProvider(AuthenticationProvider authenticationProvider) {
        Assert.notNull((Object)authenticationProvider, (String)"authenticationProvider cannot be null");
        this.authenticationProviders.add(authenticationProvider);
        return this;
    }

    public OAuth2DeviceAuthorizationEndpointConfigurer authenticationProviders(Consumer<List<AuthenticationProvider>> authenticationProvidersConsumer) {
        Assert.notNull(authenticationProvidersConsumer, (String)"authenticationProvidersConsumer cannot be null");
        this.authenticationProvidersConsumer = authenticationProvidersConsumer;
        return this;
    }

    public OAuth2DeviceAuthorizationEndpointConfigurer deviceAuthorizationResponseHandler(AuthenticationSuccessHandler deviceAuthorizationResponseHandler) {
        this.deviceAuthorizationResponseHandler = deviceAuthorizationResponseHandler;
        return this;
    }

    public OAuth2DeviceAuthorizationEndpointConfigurer errorResponseHandler(AuthenticationFailureHandler errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
        return this;
    }

    public OAuth2DeviceAuthorizationEndpointConfigurer verificationUri(String verificationUri) {
        this.verificationUri = verificationUri;
        return this;
    }

    @Override
    public void init(HttpSecurity builder) {
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(builder);
        String deviceAuthorizationEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getDeviceAuthorizationEndpoint()) : authorizationServerSettings.getDeviceAuthorizationEndpoint();
        this.requestMatcher = PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.POST, deviceAuthorizationEndpointUri);
        List<AuthenticationProvider> authenticationProviders = OAuth2DeviceAuthorizationEndpointConfigurer.createDefaultAuthenticationProviders(builder);
        if (!this.authenticationProviders.isEmpty()) {
            authenticationProviders.addAll(0, this.authenticationProviders);
        }
        this.authenticationProvidersConsumer.accept(authenticationProviders);
        authenticationProviders.forEach(authenticationProvider -> builder.authenticationProvider(this.postProcess(authenticationProvider)));
    }

    @Override
    public void configure(HttpSecurity builder) {
        AuthenticationManager authenticationManager = (AuthenticationManager)builder.getSharedObject(AuthenticationManager.class);
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(builder);
        String deviceAuthorizationEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getDeviceAuthorizationEndpoint()) : authorizationServerSettings.getDeviceAuthorizationEndpoint();
        OAuth2DeviceAuthorizationEndpointFilter deviceAuthorizationEndpointFilter = new OAuth2DeviceAuthorizationEndpointFilter(authenticationManager, deviceAuthorizationEndpointUri);
        List<AuthenticationConverter> authenticationConverters = OAuth2DeviceAuthorizationEndpointConfigurer.createDefaultAuthenticationConverters();
        if (!this.deviceAuthorizationRequestConverters.isEmpty()) {
            authenticationConverters.addAll(0, this.deviceAuthorizationRequestConverters);
        }
        this.deviceAuthorizationRequestConvertersConsumer.accept(authenticationConverters);
        deviceAuthorizationEndpointFilter.setAuthenticationConverter((AuthenticationConverter)new DelegatingAuthenticationConverter(authenticationConverters));
        if (this.deviceAuthorizationResponseHandler != null) {
            deviceAuthorizationEndpointFilter.setAuthenticationSuccessHandler(this.deviceAuthorizationResponseHandler);
        }
        if (this.errorResponseHandler != null) {
            deviceAuthorizationEndpointFilter.setAuthenticationFailureHandler(this.errorResponseHandler);
        }
        if (StringUtils.hasText((String)this.verificationUri)) {
            deviceAuthorizationEndpointFilter.setVerificationUri(this.verificationUri);
        }
        builder.addFilterAfter((Filter)this.postProcess(deviceAuthorizationEndpointFilter), AuthorizationFilter.class);
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    private static List<AuthenticationConverter> createDefaultAuthenticationConverters() {
        ArrayList<AuthenticationConverter> authenticationConverters = new ArrayList<AuthenticationConverter>();
        authenticationConverters.add(new OAuth2DeviceAuthorizationRequestAuthenticationConverter());
        return authenticationConverters;
    }

    private static List<AuthenticationProvider> createDefaultAuthenticationProviders(HttpSecurity builder) {
        ArrayList<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>();
        OAuth2AuthorizationService authorizationService = OAuth2ConfigurerUtils.getAuthorizationService(builder);
        OAuth2DeviceAuthorizationRequestAuthenticationProvider deviceAuthorizationRequestAuthenticationProvider = new OAuth2DeviceAuthorizationRequestAuthenticationProvider(authorizationService);
        authenticationProviders.add(deviceAuthorizationRequestAuthenticationProvider);
        return authenticationProviders;
    }
}

