/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2DeviceCode;
import org.springframework.security.oauth2.core.OAuth2UserCode;
import org.springframework.security.oauth2.core.endpoint.OAuth2DeviceAuthorizationResponse;
import org.springframework.security.oauth2.core.http.converter.OAuth2DeviceAuthorizationResponseHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceAuthorizationRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2DeviceAuthorizationRequestAuthenticationConverter;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2ErrorAuthenticationFailureHandler;
import org.springframework.security.oauth2.server.authorization.web.util.matcher.RequestMatcherUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.util.RedirectUrlBuilder;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public final class OAuth2DeviceAuthorizationEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_DEVICE_AUTHORIZATION_ENDPOINT_URI = "/oauth2/device_authorization";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher deviceAuthorizationEndpointMatcher;
    private final HttpMessageConverter<OAuth2DeviceAuthorizationResponse> deviceAuthorizationHttpResponseConverter = new OAuth2DeviceAuthorizationResponseHttpMessageConverter();
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationConverter authenticationConverter;
    private AuthenticationSuccessHandler authenticationSuccessHandler = this::sendDeviceAuthorizationResponse;
    private AuthenticationFailureHandler authenticationFailureHandler = new OAuth2ErrorAuthenticationFailureHandler();
    private String verificationUri = "/oauth2/device_verification";

    public OAuth2DeviceAuthorizationEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_DEVICE_AUTHORIZATION_ENDPOINT_URI);
    }

    public OAuth2DeviceAuthorizationEndpointFilter(AuthenticationManager authenticationManager, String deviceAuthorizationEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)deviceAuthorizationEndpointUri, (String)"deviceAuthorizationEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.deviceAuthorizationEndpointMatcher = RequestMatcherUtils.matcher(deviceAuthorizationEndpointUri, HttpMethod.POST);
        this.authenticationConverter = new OAuth2DeviceAuthorizationRequestAuthenticationConverter();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.deviceAuthorizationEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication deviceAuthorizationRequestAuthentication = this.authenticationConverter.convert(request);
            if (deviceAuthorizationRequestAuthentication instanceof AbstractAuthenticationToken) {
                AbstractAuthenticationToken authenticationToken = (AbstractAuthenticationToken)deviceAuthorizationRequestAuthentication;
                authenticationToken.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            }
            Authentication deviceAuthorizationRequestAuthenticationResult = this.authenticationManager.authenticate(deviceAuthorizationRequestAuthentication);
            this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, deviceAuthorizationRequestAuthenticationResult);
        }
        catch (OAuth2AuthenticationException ex) {
            SecurityContextHolder.clearContext();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Device authorization request failed: %s", (Object)ex.getError()), (Throwable)ex);
            }
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)ex);
        }
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"authenticationDetailsSource cannot be null");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public void setVerificationUri(String verificationUri) {
        Assert.hasText((String)verificationUri, (String)"verificationUri cannot be empty");
        this.verificationUri = verificationUri;
    }

    private void sendDeviceAuthorizationResponse(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        OAuth2DeviceAuthorizationRequestAuthenticationToken deviceAuthorizationRequestAuthentication = (OAuth2DeviceAuthorizationRequestAuthenticationToken)authentication;
        OAuth2DeviceCode deviceCode = deviceAuthorizationRequestAuthentication.getDeviceCode();
        OAuth2UserCode userCode = deviceAuthorizationRequestAuthentication.getUserCode();
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)this.resolveVerificationUri(request));
        String verificationUri = uriComponentsBuilder.build().toUriString();
        String verificationUriComplete = uriComponentsBuilder.queryParam("user_code", new Object[]{userCode.getTokenValue()}).build().toUriString();
        OAuth2DeviceAuthorizationResponse deviceAuthorizationResponse = OAuth2DeviceAuthorizationResponse.with((OAuth2DeviceCode)deviceCode, (OAuth2UserCode)userCode).verificationUri(verificationUri).verificationUriComplete(verificationUriComplete).build();
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.deviceAuthorizationHttpResponseConverter.write((Object)deviceAuthorizationResponse, null, (HttpOutputMessage)httpResponse);
    }

    private String resolveVerificationUri(HttpServletRequest request) {
        if (UrlUtils.isAbsoluteUrl((String)this.verificationUri)) {
            return this.verificationUri;
        }
        RedirectUrlBuilder urlBuilder = new RedirectUrlBuilder();
        urlBuilder.setScheme(request.getScheme());
        urlBuilder.setServerName(request.getServerName());
        urlBuilder.setPort(request.getServerPort());
        urlBuilder.setContextPath(request.getContextPath());
        urlBuilder.setPathInfo(this.verificationUri);
        return urlBuilder.getUrl();
    }
}

