/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientCredentialsAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OAuth2ClientCredentialsAuthenticationConverter
implements AuthenticationConverter {
    @Nullable
    public Authentication convert(HttpServletRequest request) {
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getFormParameters(request);
        String grantType = (String)parameters.getFirst((Object)"grant_type");
        if (!AuthorizationGrantType.CLIENT_CREDENTIALS.getValue().equals(grantType)) {
            return null;
        }
        Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
        String scope = (String)parameters.getFirst((Object)"scope");
        if (StringUtils.hasText((String)scope) && ((List)parameters.get((Object)"scope")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "scope", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        HashSet<String> requestedScopes = null;
        if (StringUtils.hasText((String)scope)) {
            requestedScopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!key.equals("grant_type") && !key.equals("scope")) {
                additionalParameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0]));
            }
        });
        OAuth2EndpointUtils.validateAndAddDPoPParametersIfAvailable(request, additionalParameters);
        return new OAuth2ClientCredentialsAuthenticationToken(clientPrincipal, requestedScopes, additionalParameters);
    }
}

