/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeGenerator;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceAuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.token.DefaultOAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OAuth2AuthorizationConsentAuthenticationProvider
implements AuthenticationProvider {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2.1";
    private static final OAuth2TokenType STATE_TOKEN_TYPE = new OAuth2TokenType("state");
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private final OAuth2AuthorizationConsentService authorizationConsentService;
    private OAuth2TokenGenerator<OAuth2AuthorizationCode> authorizationCodeGenerator = new OAuth2AuthorizationCodeGenerator();
    private Consumer<OAuth2AuthorizationConsentAuthenticationContext> authorizationConsentCustomizer;

    public OAuth2AuthorizationConsentAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService, OAuth2AuthorizationConsentService authorizationConsentService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.notNull((Object)authorizationConsentService, (String)"authorizationConsentService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        this.authorizationConsentService = authorizationConsentService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String redirectUri;
        OAuth2TokenContext tokenContext;
        OAuth2AuthorizationCode authorizationCode;
        OAuth2AuthorizationConsent authorizationConsent;
        OAuth2AuthorizationConsent.Builder authorizationConsentBuilder;
        OAuth2AuthorizationConsent currentAuthorizationConsent;
        Set<Object> currentAuthorizedScopes;
        HashSet<String> authorizedScopes;
        OAuth2AuthorizationRequest authorizationRequest;
        Set requestedScopes;
        RegisteredClient registeredClient;
        Authentication principal;
        if (authentication instanceof OAuth2DeviceAuthorizationConsentAuthenticationToken) {
            return null;
        }
        OAuth2AuthorizationConsentAuthenticationToken authorizationConsentAuthentication = (OAuth2AuthorizationConsentAuthenticationToken)authentication;
        OAuth2Authorization authorization = this.authorizationService.findByToken(authorizationConsentAuthentication.getState(), STATE_TOKEN_TYPE);
        if (authorization == null) {
            OAuth2AuthorizationConsentAuthenticationProvider.throwError("invalid_request", "state", authorizationConsentAuthentication, null, null);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved authorization with authorization consent state");
        }
        if (!OAuth2AuthorizationConsentAuthenticationProvider.isPrincipalAuthenticated(principal = (Authentication)authorizationConsentAuthentication.getPrincipal()) || !principal.getName().equals(authorization.getPrincipalName())) {
            OAuth2AuthorizationConsentAuthenticationProvider.throwError("invalid_request", "state", authorizationConsentAuthentication, null, null);
        }
        if ((registeredClient = this.registeredClientRepository.findByClientId(authorizationConsentAuthentication.getClientId())) == null || !registeredClient.getId().equals(authorization.getRegisteredClientId())) {
            OAuth2AuthorizationConsentAuthenticationProvider.throwError("invalid_request", "client_id", authorizationConsentAuthentication, registeredClient, null);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved registered client");
        }
        if (!(requestedScopes = (authorizationRequest = (OAuth2AuthorizationRequest)authorization.getAttribute(OAuth2AuthorizationRequest.class.getName())).getScopes()).containsAll(authorizedScopes = new HashSet<String>(authorizationConsentAuthentication.getScopes()))) {
            OAuth2AuthorizationConsentAuthenticationProvider.throwError("invalid_scope", "scope", authorizationConsentAuthentication, registeredClient, authorizationRequest);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated authorization consent request parameters");
        }
        Set<Object> set = currentAuthorizedScopes = (currentAuthorizationConsent = this.authorizationConsentService.findById(authorization.getRegisteredClientId(), authorization.getPrincipalName())) != null ? currentAuthorizationConsent.getScopes() : Collections.emptySet();
        if (!currentAuthorizedScopes.isEmpty()) {
            for (String requestedScope : requestedScopes) {
                if (!currentAuthorizedScopes.contains(requestedScope)) continue;
                authorizedScopes.add(requestedScope);
            }
        }
        if (!authorizedScopes.isEmpty() && requestedScopes.contains("openid")) {
            authorizedScopes.add("openid");
        }
        if (currentAuthorizationConsent != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Retrieved existing authorization consent");
            }
            authorizationConsentBuilder = OAuth2AuthorizationConsent.from(currentAuthorizationConsent);
        } else {
            authorizationConsentBuilder = OAuth2AuthorizationConsent.withId(authorization.getRegisteredClientId(), authorization.getPrincipalName());
        }
        authorizedScopes.forEach(authorizationConsentBuilder::scope);
        if (this.authorizationConsentCustomizer != null) {
            OAuth2AuthorizationConsentAuthenticationContext authorizationConsentAuthenticationContext = OAuth2AuthorizationConsentAuthenticationContext.with(authorizationConsentAuthentication).authorizationConsent(authorizationConsentBuilder).registeredClient(registeredClient).authorization(authorization).authorizationRequest(authorizationRequest).build();
            this.authorizationConsentCustomizer.accept(authorizationConsentAuthenticationContext);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Customized authorization consent");
            }
        }
        HashSet authorities = new HashSet();
        authorizationConsentBuilder.authorities(authorities::addAll);
        if (authorities.isEmpty()) {
            if (currentAuthorizationConsent != null) {
                this.authorizationConsentService.remove(currentAuthorizationConsent);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)"Revoked authorization consent");
                }
            }
            this.authorizationService.remove(authorization);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Removed authorization");
            }
            OAuth2AuthorizationConsentAuthenticationProvider.throwError("access_denied", "client_id", authorizationConsentAuthentication, registeredClient, authorizationRequest);
        }
        if (!(authorizationConsent = authorizationConsentBuilder.build()).equals(currentAuthorizationConsent)) {
            this.authorizationConsentService.save(authorizationConsent);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Saved authorization consent");
            }
        }
        if ((authorizationCode = this.authorizationCodeGenerator.generate(tokenContext = OAuth2AuthorizationConsentAuthenticationProvider.createAuthorizationCodeTokenContext(authorizationConsentAuthentication, registeredClient, authorization, authorizedScopes))) == null) {
            OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the authorization code.", ERROR_URI);
            throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, null);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Generated authorization code");
        }
        OAuth2Authorization updatedAuthorization = OAuth2Authorization.from(authorization).authorizedScopes(authorizedScopes).token(authorizationCode).attributes(attrs -> attrs.remove("state")).build();
        this.authorizationService.save(updatedAuthorization);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Saved authorization");
        }
        if (!StringUtils.hasText((String)(redirectUri = authorizationRequest.getRedirectUri()))) {
            redirectUri = registeredClient.getRedirectUris().iterator().next();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated authorization consent request");
        }
        return new OAuth2AuthorizationCodeRequestAuthenticationToken(authorizationRequest.getAuthorizationUri(), registeredClient.getClientId(), principal, authorizationCode, redirectUri, authorizationRequest.getState(), authorizedScopes);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2AuthorizationConsentAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setAuthorizationCodeGenerator(OAuth2TokenGenerator<OAuth2AuthorizationCode> authorizationCodeGenerator) {
        Assert.notNull(authorizationCodeGenerator, (String)"authorizationCodeGenerator cannot be null");
        this.authorizationCodeGenerator = authorizationCodeGenerator;
    }

    public void setAuthorizationConsentCustomizer(Consumer<OAuth2AuthorizationConsentAuthenticationContext> authorizationConsentCustomizer) {
        Assert.notNull(authorizationConsentCustomizer, (String)"authorizationConsentCustomizer cannot be null");
        this.authorizationConsentCustomizer = authorizationConsentCustomizer;
    }

    private static OAuth2TokenContext createAuthorizationCodeTokenContext(OAuth2AuthorizationConsentAuthenticationToken authorizationConsentAuthentication, RegisteredClient registeredClient, OAuth2Authorization authorization, Set<String> authorizedScopes) {
        return ((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)DefaultOAuth2TokenContext.builder().registeredClient(registeredClient)).principal((Authentication)authorizationConsentAuthentication.getPrincipal())).authorization(authorization)).authorizationServerContext(AuthorizationServerContextHolder.getContext())).tokenType(new OAuth2TokenType("code"))).authorizedScopes(authorizedScopes)).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE)).authorizationGrant((Authentication)authorizationConsentAuthentication)).build();
    }

    private static boolean isPrincipalAuthenticated(Authentication principal) {
        return principal != null && !AnonymousAuthenticationToken.class.isAssignableFrom(principal.getClass()) && principal.isAuthenticated();
    }

    private static void throwError(String errorCode, String parameterName, OAuth2AuthorizationConsentAuthenticationToken authorizationConsentAuthentication, RegisteredClient registeredClient, OAuth2AuthorizationRequest authorizationRequest) {
        OAuth2Error error = new OAuth2Error(errorCode, "OAuth 2.0 Parameter: " + parameterName, ERROR_URI);
        OAuth2AuthorizationConsentAuthenticationProvider.throwError(error, parameterName, authorizationConsentAuthentication, registeredClient, authorizationRequest);
    }

    private static void throwError(OAuth2Error error, String parameterName, OAuth2AuthorizationConsentAuthenticationToken authorizationConsentAuthentication, RegisteredClient registeredClient, OAuth2AuthorizationRequest authorizationRequest) {
        String redirectUri = OAuth2AuthorizationConsentAuthenticationProvider.resolveRedirectUri(authorizationRequest, registeredClient);
        if (error.getErrorCode().equals("invalid_request") && (parameterName.equals("client_id") || parameterName.equals("state"))) {
            redirectUri = null;
        }
        String state = authorizationRequest != null ? authorizationRequest.getState() : authorizationConsentAuthentication.getState();
        Set<String> requestedScopes = authorizationRequest != null ? authorizationRequest.getScopes() : authorizationConsentAuthentication.getScopes();
        OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthenticationResult = new OAuth2AuthorizationCodeRequestAuthenticationToken(authorizationConsentAuthentication.getAuthorizationUri(), authorizationConsentAuthentication.getClientId(), (Authentication)authorizationConsentAuthentication.getPrincipal(), redirectUri, state, requestedScopes, null);
        throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, authorizationCodeRequestAuthenticationResult);
    }

    private static String resolveRedirectUri(OAuth2AuthorizationRequest authorizationRequest, RegisteredClient registeredClient) {
        if (authorizationRequest != null && StringUtils.hasText((String)authorizationRequest.getRedirectUri())) {
            return authorizationRequest.getRedirectUri();
        }
        if (registeredClient != null) {
            return registeredClient.getRedirectUris().iterator().next();
        }
        return null;
    }
}

