/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;
import org.springframework.util.Assert;

public class OAuth2AuthorizationCodeAuthenticationToken
extends OAuth2AuthorizationGrantAuthenticationToken {
    private final String code;
    private final String redirectUri;

    public OAuth2AuthorizationCodeAuthenticationToken(String code, Authentication clientPrincipal, @Nullable String redirectUri, @Nullable Map<String, Object> additionalParameters) {
        super(AuthorizationGrantType.AUTHORIZATION_CODE, clientPrincipal, additionalParameters);
        Assert.hasText((String)code, (String)"code cannot be empty");
        this.code = code;
        this.redirectUri = redirectUri;
    }

    public String getCode() {
        return this.code;
    }

    @Nullable
    public String getRedirectUri() {
        return this.redirectUri;
    }
}

