/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class ClientSecretPostAuthenticationConverter
implements AuthenticationConverter {
    @Nullable
    public Authentication convert(HttpServletRequest request) {
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getFormParameters(request);
        String clientId = (String)parameters.getFirst((Object)"client_id");
        if (!StringUtils.hasText((String)clientId)) {
            return null;
        }
        if (((List)parameters.get((Object)"client_id")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        String clientSecret = (String)parameters.getFirst((Object)"client_secret");
        if (!StringUtils.hasText((String)clientSecret)) {
            return null;
        }
        if (((List)parameters.get((Object)"client_secret")).size() != 1) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        Map<String, Object> additionalParameters = OAuth2EndpointUtils.getParametersIfMatchesAuthorizationCodeGrantRequest(request, "client_id", "client_secret");
        return new OAuth2ClientAuthenticationToken(clientId, ClientAuthenticationMethod.CLIENT_SECRET_POST, clientSecret, additionalParameters);
    }
}

