/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationToken;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public final class OidcLogoutAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private final SecurityContextLogoutHandler securityContextLogoutHandler = new SecurityContextLogoutHandler();
    private LogoutHandler logoutHandler = this::performLogout;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        if (!(authentication instanceof OidcLogoutAuthenticationToken)) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)(Authentication.class.getSimpleName() + " must be of type " + OidcLogoutAuthenticationToken.class.getName() + " but was " + authentication.getClass().getName()));
            }
            OAuth2Error error = new OAuth2Error("server_error", "Unable to process the OpenID Connect 1.0 RP-Initiated Logout response.", null);
            throw new OAuth2AuthenticationException(error);
        }
        this.logoutHandler.logout(request, response, authentication);
        this.sendLogoutRedirect(request, response, authentication);
    }

    public void setLogoutHandler(LogoutHandler logoutHandler) {
        Assert.notNull((Object)logoutHandler, (String)"logoutHandler cannot be null");
        this.logoutHandler = logoutHandler;
    }

    private void performLogout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        OidcLogoutAuthenticationToken oidcLogoutAuthentication = (OidcLogoutAuthenticationToken)authentication;
        if (oidcLogoutAuthentication.isPrincipalAuthenticated()) {
            this.securityContextLogoutHandler.logout(request, response, (Authentication)oidcLogoutAuthentication.getPrincipal());
        }
    }

    private void sendLogoutRedirect(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        OidcLogoutAuthenticationToken oidcLogoutAuthentication = (OidcLogoutAuthenticationToken)authentication;
        String redirectUri = "/";
        if (oidcLogoutAuthentication.isAuthenticated() && StringUtils.hasText((String)oidcLogoutAuthentication.getPostLogoutRedirectUri())) {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)oidcLogoutAuthentication.getPostLogoutRedirectUri());
            if (StringUtils.hasText((String)oidcLogoutAuthentication.getState())) {
                uriBuilder.queryParam("state", new Object[]{UriUtils.encode((String)oidcLogoutAuthentication.getState(), (Charset)StandardCharsets.UTF_8)});
            }
            redirectUri = uriBuilder.build(true).toUriString();
        }
        this.redirectStrategy.sendRedirect(request, response, redirectUri);
    }
}

