/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;
import org.springframework.util.Assert;

public class OAuth2DeviceCodeAuthenticationToken
extends OAuth2AuthorizationGrantAuthenticationToken {
    private final String deviceCode;

    public OAuth2DeviceCodeAuthenticationToken(String deviceCode, Authentication clientPrincipal, @Nullable Map<String, Object> additionalParameters) {
        super(AuthorizationGrantType.DEVICE_CODE, clientPrincipal, additionalParameters);
        Assert.hasText((String)deviceCode, (String)"deviceCode cannot be empty");
        this.deviceCode = deviceCode;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }
}

