/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationToken;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OidcLogoutAuthenticationConverter
implements AuthenticationConverter {
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));

    public Authentication convert(HttpServletRequest request) {
        String state;
        String postLogoutRedirectUri;
        String clientId;
        Authentication principal;
        MultiValueMap<String, String> parameters = OidcLogoutAuthenticationConverter.getParameters(request);
        String idTokenHint = request.getParameter("id_token_hint");
        if (!StringUtils.hasText((String)idTokenHint) || request.getParameterValues("id_token_hint").length != 1) {
            OidcLogoutAuthenticationConverter.throwError("invalid_request", "id_token_hint");
        }
        if ((principal = SecurityContextHolder.getContext().getAuthentication()) == null) {
            principal = ANONYMOUS_AUTHENTICATION;
        }
        String sessionId = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            sessionId = session.getId();
        }
        if (StringUtils.hasText((String)(clientId = (String)parameters.getFirst((Object)"client_id"))) && ((List)parameters.get((Object)"client_id")).size() != 1) {
            OidcLogoutAuthenticationConverter.throwError("invalid_request", "client_id");
        }
        if (StringUtils.hasText((String)(postLogoutRedirectUri = (String)parameters.getFirst((Object)"post_logout_redirect_uri"))) && ((List)parameters.get((Object)"post_logout_redirect_uri")).size() != 1) {
            OidcLogoutAuthenticationConverter.throwError("invalid_request", "post_logout_redirect_uri");
        }
        if (StringUtils.hasText((String)(state = (String)parameters.getFirst((Object)"state"))) && ((List)parameters.get((Object)"state")).size() != 1) {
            OidcLogoutAuthenticationConverter.throwError("invalid_request", "state");
        }
        return new OidcLogoutAuthenticationToken(idTokenHint, principal, sessionId, clientId, postLogoutRedirectUri, state);
    }

    private static MultiValueMap<String, String> getParameters(HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        LinkedMultiValueMap parameters = new LinkedMultiValueMap(parameterMap.size());
        parameterMap.forEach((arg_0, arg_1) -> OidcLogoutAuthenticationConverter.lambda$getParameters$0((MultiValueMap)parameters, arg_0, arg_1));
        return parameters;
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OpenID Connect 1.0 Logout Request Parameter: " + parameterName, "https://openid.net/specs/openid-connect-rpinitiated-1_0.html#ValidationAndErrorHandling");
        throw new OAuth2AuthenticationException(error);
    }

    private static /* synthetic */ void lambda$getParameters$0(MultiValueMap parameters, String key, String[] values) {
        if (values.length > 0) {
            for (String value : values) {
                parameters.add((Object)key, (Object)value);
            }
        }
    }
}

