/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.config.annotation.web.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;

final class RegisterMissingBeanPostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware {
    private final AnnotationBeanNameGenerator beanNameGenerator = new AnnotationBeanNameGenerator();
    private final List<AbstractBeanDefinition> beanDefinitions = new ArrayList<AbstractBeanDefinition>();
    private BeanFactory beanFactory;

    RegisterMissingBeanPostProcessor() {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        for (AbstractBeanDefinition beanDefinition : this.beanDefinitions) {
            String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)this.beanFactory), (Class)beanDefinition.getBeanClass(), (boolean)false, (boolean)false);
            if (beanNames.length != 0) continue;
            String beanName = this.beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, registry);
            registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    <T> void addBeanDefinition(Class<T> beanClass, Supplier<T> beanSupplier) {
        this.beanDefinitions.add((AbstractBeanDefinition)new RootBeanDefinition(beanClass, beanSupplier));
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

