/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.authentication;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.RegisteredClientOidcClientRegistrationConverter;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class OidcClientConfigurationAuthenticationProvider
implements AuthenticationProvider {
    static final String DEFAULT_CLIENT_CONFIGURATION_AUTHORIZED_SCOPE = "client.read";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private final Converter<RegisteredClient, OidcClientRegistration> clientRegistrationConverter;

    public OidcClientConfigurationAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        this.clientRegistrationConverter = new RegisteredClientOidcClientRegistrationConverter();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken;
        OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication = (OidcClientRegistrationAuthenticationToken)authentication;
        if (!StringUtils.hasText((String)clientRegistrationAuthentication.getClientId())) {
            return null;
        }
        AbstractOAuth2TokenAuthenticationToken accessTokenAuthentication = null;
        if (AbstractOAuth2TokenAuthenticationToken.class.isAssignableFrom(clientRegistrationAuthentication.getPrincipal().getClass())) {
            accessTokenAuthentication = (AbstractOAuth2TokenAuthenticationToken)clientRegistrationAuthentication.getPrincipal();
        }
        if (accessTokenAuthentication == null || !accessTokenAuthentication.isAuthenticated()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        String accessTokenValue = accessTokenAuthentication.getToken().getTokenValue();
        OAuth2Authorization authorization = this.authorizationService.findByToken(accessTokenValue, OAuth2TokenType.ACCESS_TOKEN);
        if (authorization == null) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved authorization with access token");
        }
        if (!(authorizedAccessToken = authorization.getAccessToken()).isActive()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        OidcClientConfigurationAuthenticationProvider.checkScope(authorizedAccessToken, Collections.singleton(DEFAULT_CLIENT_CONFIGURATION_AUTHORIZED_SCOPE));
        return this.findRegistration(clientRegistrationAuthentication, authorization);
    }

    public boolean supports(Class<?> authentication) {
        return OidcClientRegistrationAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private OidcClientRegistrationAuthenticationToken findRegistration(OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication, OAuth2Authorization authorization) {
        RegisteredClient registeredClient = this.registeredClientRepository.findByClientId(clientRegistrationAuthentication.getClientId());
        if (registeredClient == null) {
            throw new OAuth2AuthenticationException("invalid_client");
        }
        if (!registeredClient.getId().equals(authorization.getRegisteredClientId())) {
            throw new OAuth2AuthenticationException("invalid_client");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated client configuration request parameters");
        }
        OidcClientRegistration clientRegistration = (OidcClientRegistration)this.clientRegistrationConverter.convert((Object)registeredClient);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated client configuration request");
        }
        return new OidcClientRegistrationAuthenticationToken((Authentication)clientRegistrationAuthentication.getPrincipal(), clientRegistration);
    }

    private static void checkScope(OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken, Set<String> requiredScope) {
        Collection<Object> authorizedScope = Collections.emptySet();
        if (authorizedAccessToken.getClaims().containsKey("scope")) {
            authorizedScope = (Collection)authorizedAccessToken.getClaims().get("scope");
        }
        if (!authorizedScope.containsAll(requiredScope)) {
            throw new OAuth2AuthenticationException("insufficient_scope");
        }
        if (authorizedScope.size() != requiredScope.size()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
    }
}

