/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.settings;

import java.util.Map;
import org.springframework.security.oauth2.server.authorization.settings.AbstractSettings;
import org.springframework.security.oauth2.server.authorization.settings.ConfigurationSettingNames;
import org.springframework.util.Assert;

public final class AuthorizationServerSettings
extends AbstractSettings {
    private AuthorizationServerSettings(Map<String, Object> settings) {
        super(settings);
    }

    public String getIssuer() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.ISSUER);
    }

    public String getAuthorizationEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.AUTHORIZATION_ENDPOINT);
    }

    public String getTokenEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.TOKEN_ENDPOINT);
    }

    public String getJwkSetEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.JWK_SET_ENDPOINT);
    }

    public String getTokenRevocationEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.TOKEN_REVOCATION_ENDPOINT);
    }

    public String getTokenIntrospectionEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.TOKEN_INTROSPECTION_ENDPOINT);
    }

    public String getOidcClientRegistrationEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.OIDC_CLIENT_REGISTRATION_ENDPOINT);
    }

    public String getOidcUserInfoEndpoint() {
        return (String)this.getSetting(ConfigurationSettingNames.AuthorizationServer.OIDC_USER_INFO_ENDPOINT);
    }

    public static Builder builder() {
        return new Builder().authorizationEndpoint("/oauth2/authorize").tokenEndpoint("/oauth2/token").jwkSetEndpoint("/oauth2/jwks").tokenRevocationEndpoint("/oauth2/revoke").tokenIntrospectionEndpoint("/oauth2/introspect").oidcClientRegistrationEndpoint("/connect/register").oidcUserInfoEndpoint("/userinfo");
    }

    public static Builder withSettings(Map<String, Object> settings) {
        Assert.notEmpty(settings, (String)"settings cannot be empty");
        return (Builder)new Builder().settings(s -> s.putAll(settings));
    }

    public static final class Builder
    extends AbstractSettings.AbstractBuilder<AuthorizationServerSettings, Builder> {
        private Builder() {
        }

        public Builder issuer(String issuer) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.ISSUER, issuer);
        }

        public Builder authorizationEndpoint(String authorizationEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.AUTHORIZATION_ENDPOINT, authorizationEndpoint);
        }

        public Builder tokenEndpoint(String tokenEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.TOKEN_ENDPOINT, tokenEndpoint);
        }

        public Builder jwkSetEndpoint(String jwkSetEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.JWK_SET_ENDPOINT, jwkSetEndpoint);
        }

        public Builder tokenRevocationEndpoint(String tokenRevocationEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.TOKEN_REVOCATION_ENDPOINT, tokenRevocationEndpoint);
        }

        public Builder tokenIntrospectionEndpoint(String tokenIntrospectionEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.TOKEN_INTROSPECTION_ENDPOINT, tokenIntrospectionEndpoint);
        }

        public Builder oidcClientRegistrationEndpoint(String oidcClientRegistrationEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.OIDC_CLIENT_REGISTRATION_ENDPOINT, oidcClientRegistrationEndpoint);
        }

        public Builder oidcUserInfoEndpoint(String oidcUserInfoEndpoint) {
            return (Builder)this.setting(ConfigurationSettingNames.AuthorizationServer.OIDC_USER_INFO_ENDPOINT, oidcUserInfoEndpoint);
        }

        @Override
        public AuthorizationServerSettings build() {
            return new AuthorizationServerSettings(this.getSettings());
        }
    }
}

